/*
 * Decompiled with CFR 0.152.
 */
package org.mangorage.mangobot.modules.tricks;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import net.dv8tion.jda.api.entities.Guild;
import net.dv8tion.jda.api.entities.Member;
import net.dv8tion.jda.api.entities.Message;
import net.dv8tion.jda.api.entities.User;
import net.dv8tion.jda.api.entities.channel.middleman.MessageChannel;
import net.dv8tion.jda.api.entities.channel.unions.MessageChannelUnion;
import net.dv8tion.jda.api.events.interaction.ModalInteractionEvent;
import net.dv8tion.jda.api.events.interaction.component.ButtonInteractionEvent;
import net.dv8tion.jda.api.interactions.commands.OptionMapping;
import net.dv8tion.jda.api.interactions.commands.OptionType;
import net.dv8tion.jda.api.interactions.components.ActionRow;
import net.dv8tion.jda.api.interactions.components.ItemComponent;
import net.dv8tion.jda.api.interactions.components.LayoutComponent;
import net.dv8tion.jda.api.interactions.components.buttons.Button;
import net.dv8tion.jda.api.interactions.components.text.TextInput;
import net.dv8tion.jda.api.interactions.components.text.TextInputStyle;
import net.dv8tion.jda.api.interactions.modals.Modal;
import net.dv8tion.jda.api.interactions.modals.ModalMapping;
import net.dv8tion.jda.api.requests.restaction.MessageCreateAction;
import net.dv8tion.jda.api.requests.restaction.MessageEditAction;
import net.dv8tion.jda.api.requests.restaction.interactions.ReplyCallbackAction;
import net.dv8tion.jda.api.utils.MarkdownSanitizer;
import org.jetbrains.annotations.NotNull;
import org.mangorage.basicutils.LogHelper;
import org.mangorage.basicutils.TaskScheduler;
import org.mangorage.basicutils.misc.PagedList;
import org.mangorage.basicutils.misc.RunnableTask;
import org.mangorage.jdautils.command.Command;
import org.mangorage.jdautils.command.CommandOption;
import org.mangorage.mangobot.MangoBotPlugin;
import org.mangorage.mangobot.modules.tricks.Trick;
import org.mangorage.mangobot.modules.tricks.TrickCMDType;
import org.mangorage.mangobot.modules.tricks.TrickKey;
import org.mangorage.mangobot.modules.tricks.TrickScriptable;
import org.mangorage.mangobot.modules.tricks.TrickType;
import org.mangorage.mangobotapi.core.commands.Arguments;
import org.mangorage.mangobotapi.core.commands.CommandAlias;
import org.mangorage.mangobotapi.core.commands.CommandResult;
import org.mangorage.mangobotapi.core.commands.IBasicCommand;
import org.mangorage.mangobotapi.core.data.DataHandler;
import org.mangorage.mangobotapi.core.data.IFileNameResolver;
import org.mangorage.mangobotapi.core.events.BasicCommandEvent;
import org.mangorage.mangobotapi.core.events.DiscordEvent;
import org.mangorage.mangobotapi.core.events.LoadEvent;
import org.mangorage.mangobotapi.core.events.SaveEvent;
import org.mangorage.mangobotapi.core.modules.action.TrashButtonAction;
import org.mangorage.mangobotapi.core.plugin.api.CorePlugin;
import org.mangorage.mangobotapi.core.util.MessageSettings;

public class TrickCommand
implements IBasicCommand {
    private static final boolean ALLOW_SCRIPT_TRICKS = true;
    private final CorePlugin plugin;
    private final DataHandler<Trick> TRICK_DATA_HANDLER = DataHandler.create().path("data/tricksV2").maxDepth(3).build(Trick.class);
    private final Map<TrickKey, Trick> TRICKS = new HashMap<TrickKey, Trick>();
    private final Map<String, PagedList<String>> PAGES = new ConcurrentHashMap<String, PagedList<String>>();
    private TrickScriptable SCRIPT_RUNNER;

    private Trick getTrick(String trickId, long guildId) {
        return this.TRICKS.get(new TrickKey(trickId, guildId));
    }

    private List<Trick> getTricksForGuild(long guildId) {
        return this.TRICKS.entrySet().stream().filter(e -> ((TrickKey)e.getKey()).guildId() == guildId).map(Map.Entry::getValue).toList();
    }

    public TrickCommand(CorePlugin plugin) {
        this.plugin = plugin;
        this.SCRIPT_RUNNER = new TrickScriptable(plugin);
        plugin.getPluginBus().addListener(10, LoadEvent.class, this::onLoadEvent);
        plugin.getPluginBus().addListener(10, SaveEvent.class, this::onSaveEvent);
        plugin.getPluginBus().addListener(10, BasicCommandEvent.class, this::onCommandEvent);
        plugin.getPluginBus().addGenericListener(10, ButtonInteractionEvent.class, DiscordEvent.class, this::onButton);
        plugin.getPluginBus().addGenericListener(10, ModalInteractionEvent.class, DiscordEvent.class, this::onModal);
        Command.slash((String)"trick", (String)"The Trick System").addSubCommand("execute", "Execute a trick!").executes(e -> {
            Guild g;
            OptionMapping valueOption = e.getInteraction().getOption("name");
            if (valueOption != null && (g = e.getGuild()) != null) {
                long gid = g.getIdLong();
                Trick trick = this.getTrick(valueOption.getAsString(), gid);
                if (trick != null) {
                    this.useTrick(trick, null, (MessageChannel)e.getChannel(), gid, Arguments.of((String[])new String[0]));
                    e.reply("Executed Trick!").setEphemeral(true).queue();
                    return;
                }
            }
            e.reply("Failed to execute trick!").setEphemeral(true).queue();
        }).addOption(new CommandOption(OptionType.STRING, "name", "desc", false, true).onAutoComplete(e -> {
            long id;
            List<Trick> entries;
            Guild guild = e.getGuild();
            if (guild != null && (entries = this.getTricksForGuild(id = guild.getIdLong())) != null) {
                e.replyChoiceStrings(entries.stream().filter(k -> k.getType() == TrickType.NORMAL).map(Trick::getTrickID).limit(25L).toList()).queue();
            }
        })).build().addSubCommand("create", "Creates a new Trick!").executes(e -> {
            String type;
            OptionMapping typeOption = e.getOption("type");
            String string = type = typeOption != null ? typeOption.getAsString() : "";
            if (type.equals("NORMAL") || type.equals("SUPPRESSED-NORMAL")) {
                e.replyModal(Modal.create((String)("trickcreation" + (type.equals("NORMAL") ? 0 : 1)), (String)"Create a new %s Trick!".formatted(type.toLowerCase())).addComponents(new LayoutComponent[]{ActionRow.of((ItemComponent[])new ItemComponent[]{TextInput.create((String)"trickid", (String)"Trick ID", (TextInputStyle)TextInputStyle.SHORT).setRequired(true).build()}), ActionRow.of((ItemComponent[])new ItemComponent[]{TextInput.create((String)"content", (String)"Content", (TextInputStyle)TextInputStyle.PARAGRAPH).setRequired(true).setMaxLength(1900).build()})}).build()).queue();
            } else {
                e.replyModal(Modal.create((String)"trickcreation2", (String)"Create a new %s Trick!".formatted(type.toLowerCase())).addComponents(new LayoutComponent[]{ActionRow.of((ItemComponent[])new ItemComponent[]{TextInput.create((String)"trickid", (String)"Trick ID", (TextInputStyle)TextInputStyle.SHORT).setRequired(true).build()}), ActionRow.of((ItemComponent[])new ItemComponent[]{TextInput.create((String)"alias", (String)"Alias", (TextInputStyle)TextInputStyle.SHORT).setRequired(true).setMaxLength(30).build()})}).build()).queue();
            }
        }).addOption(new CommandOption(OptionType.STRING, "type", "What type of Trick?", true, true).onAutoComplete(e -> e.replyChoiceStrings(new String[]{"NORMAL", "SUPPRESSED-NORMAL", "ALIAS"}).queue())).build().buildAndRegister();
    }

    public void onModal(DiscordEvent<ModalInteractionEvent> event) {
        ModalInteractionEvent DEvent = (ModalInteractionEvent)event.getInstance();
        Guild guild = DEvent.getGuild();
        User user = DEvent.getUser();
        if (guild == null) {
            ((ReplyCallbackAction)DEvent.deferReply(true).setContent("Cannot Add Trick. Only works in guilds.\n")).queue();
        } else {
            String modalID = DEvent.getModalId();
            if (modalID.equals("trickcreation")) {
                ModalMapping trickID = DEvent.getInteraction().getValue("trickid");
                ModalMapping content = DEvent.getInteraction().getValue("content");
                if (trickID != null && content != null) {
                    if (this.exists(trickID.getAsString(), guild.getIdLong())) {
                        DEvent.reply("Cannot create trick '%s' already exists!".formatted(trickID.getAsString())).queue();
                    } else {
                        Trick newTrick = new Trick(trickID.getAsString(), guild.getIdLong());
                        newTrick.setLastUserEdited(user.getIdLong());
                        newTrick.setOwnerID(user.getIdLong());
                        newTrick.setType(TrickType.NORMAL);
                        newTrick.setContent(content.getAsString());
                        this.save(newTrick);
                        this.TRICKS.put(new TrickKey(trickID.getAsString(), guild.getIdLong()), newTrick);
                        DEvent.reply("Created new trick '%s'!".formatted(trickID.getAsString())).queue();
                    }
                }
            }
        }
    }

    public void onLoadEvent(LoadEvent event) {
        LogHelper.info((String)"Loading Tricks Data!");
        this.TRICK_DATA_HANDLER.load(this.plugin.getPluginDirectory()).forEach(data -> this.TRICKS.put(new TrickKey(data.getTrickID(), data.getGuildID()), (Trick)data));
        LogHelper.info((String)"Finished loading Tricks Data!");
    }

    public void onSaveEvent(SaveEvent event) {
        LogHelper.info((String)"Saving Tricks Data!");
        this.TRICKS.forEach((k, v) -> this.save((Trick)v));
    }

    public void onCommandEvent(BasicCommandEvent event) {
        if (!event.isHandled()) {
            Message message = event.getMessage();
            if (!message.isFromGuild()) {
                return;
            }
            long guildID = message.getGuild().getIdLong();
            String command = event.getCommand().toLowerCase();
            String args = event.getArguments().getFrom(0);
            if (this.exists(command, guildID)) {
                event.setHandled(this.execute(message, Arguments.of((String[])new String[]{"-s", command, args})));
            }
        }
    }

    private void delete(Trick trick) {
        this.TRICK_DATA_HANDLER.delete(this.plugin.getPluginDirectory(), (IFileNameResolver[])new Trick[]{trick});
    }

    private void save(Trick trick) {
        this.TRICK_DATA_HANDLER.save(this.plugin.getPluginDirectory(), (IFileNameResolver[])new Trick[]{trick});
    }

    private boolean exists(String trickID, long guildID) {
        return this.getTrick(trickID, guildID) != null;
    }

    private boolean isOwnerAndUnlocked(Trick trick, Member member) {
        if (!trick.isLocked()) {
            return true;
        }
        return trick.getOwnerID() == member.getIdLong();
    }

    @NotNull
    public CommandResult execute(Message message, Arguments args) {
        MessageSettings dMessage = this.plugin.getMessageSettings();
        Member member = message.getMember();
        if (member == null) {
            return CommandResult.PASS;
        }
        long guildID = message.getGuild().getIdLong();
        String typeString = args.get(0);
        TrickCMDType type = typeString == null ? TrickCMDType.NONE : TrickCMDType.getType(typeString);
        String trickID = args.get(1);
        if (trickID != null) {
            trickID = trickID.toLowerCase();
        }
        boolean suppress = args.hasArg("-suppress");
        if (type == TrickCMDType.NONE) {
            return CommandResult.PASS;
        }
        if (type == TrickCMDType.ADD) {
            if (this.exists(trickID, guildID)) {
                dMessage.apply(message.reply((CharSequence)"Trick '%s' Already Exists!".formatted(trickID))).queue();
                return CommandResult.PASS;
            }
            Trick trick = new Trick(trickID, guildID);
            if (args.hasArg("-content")) {
                trick.setType(TrickType.NORMAL);
                trick.setSuppress(suppress);
                String content = args.getFrom(args.getArgIndex("-content") + 1);
                if (content == null || content.isEmpty()) {
                    dMessage.apply(message.reply((CharSequence)"Content Cannot be null/empty!")).queue();
                    return CommandResult.PASS;
                }
                trick.setContent(content);
            } else if (args.hasArg("-script")) {
                trick.setType(TrickType.SCRIPT);
                String script = args.getFrom(args.getArgIndex("-script") + 1);
                if (script == null || script.isEmpty()) {
                    dMessage.apply(message.reply((CharSequence)"Script Cannot be null/empty!")).queue();
                    return CommandResult.PASS;
                }
                trick.setScript(script);
            } else if (args.hasArg("-alias")) {
                trick.setType(TrickType.ALIAS);
                String alias = args.getFrom(args.getArgIndex("-alias") + 1);
                if (alias == null || alias.isEmpty()) {
                    dMessage.apply(message.reply((CharSequence)"Trick Cannot be null/empty!")).queue();
                    return CommandResult.PASS;
                }
                trick.setAliasTarget(alias);
            }
            trick.setOwnerID(member.getIdLong());
            trick.setLastUserEdited(member.getIdLong());
            trick.setLastEdited(System.currentTimeMillis());
            this.TRICKS.put(new TrickKey(trickID, guildID), trick);
            this.save(trick);
            dMessage.apply(message.reply((CharSequence)"Added New Trick '%s'!".formatted(trickID))).queue();
        } else if (type == TrickCMDType.MODIFY) {
            if (this.exists(trickID, guildID)) {
                Trick trick = this.getTrick(trickID, guildID);
                if (!this.isOwnerAndUnlocked(trick, member)) {
                    dMessage.apply(message.reply((CharSequence)"Cannot modify/remove Trick '%s' as your not the owner of this trick and its locked.".formatted(trickID))).queue();
                    return CommandResult.PASS;
                }
                if (args.hasArg("-content")) {
                    trick.setType(TrickType.NORMAL);
                    trick.setSuppress(suppress);
                    String content = args.getFrom(args.getArgIndex("-content") + 1);
                    if (content == null || content.isEmpty()) {
                        dMessage.apply(message.reply((CharSequence)"Content Cannot be null/empty!")).queue();
                        return CommandResult.PASS;
                    }
                    trick.setContent(content);
                } else if (args.hasArg("-script")) {
                    trick.setType(TrickType.SCRIPT);
                    String script = args.getFrom(args.getArgIndex("-script") + 1);
                    if (script == null || script.isEmpty()) {
                        dMessage.apply(message.reply((CharSequence)"Script Cannot be null/empty!")).queue();
                        return CommandResult.PASS;
                    }
                    trick.setScript(script);
                } else if (args.hasArg("-alias")) {
                    trick.setType(TrickType.ALIAS);
                    String alias = args.getFrom(args.getArgIndex("-alias") + 1);
                    if (alias == null || alias.isEmpty()) {
                        dMessage.apply(message.reply((CharSequence)"Trick Cannot be null/empty!")).queue();
                        return CommandResult.PASS;
                    }
                    trick.setAliasTarget(alias);
                }
                trick.setLastUserEdited(member.getIdLong());
                trick.setLastEdited(System.currentTimeMillis());
                this.save(trick);
                dMessage.apply(message.reply((CharSequence)"Modified Trick %s!".formatted(trickID))).queue();
                return CommandResult.PASS;
            }
            dMessage.apply(message.reply((CharSequence)"Trick '%s' does not exist!".formatted(trickID))).queue();
        } else if (type == TrickCMDType.REMOVE) {
            if (this.exists(trickID, guildID)) {
                Trick trick = this.getTrick(trickID, guildID);
                if (!this.isOwnerAndUnlocked(trick, member)) {
                    dMessage.apply(message.reply((CharSequence)"Cannot modify/remove Trick '%s' as your not the owner of this trick and its locked.".formatted(trickID))).queue();
                    return CommandResult.PASS;
                }
                this.delete(trick);
                this.TRICKS.remove(new TrickKey(trickID, guildID));
                dMessage.apply(message.reply((CharSequence)"Removed Trick %s.".formatted(trickID))).queue();
            }
        } else if (type == TrickCMDType.INFO) {
            if (!this.exists(trickID, guildID)) {
                dMessage.apply(message.reply((CharSequence)"Trick '%s' does not exist!".formatted(trickID))).queue();
                return CommandResult.PASS;
            }
            Trick trick = this.getTrick(trickID, guildID);
            Object details = "Details for Trick %s\n\nType -> %s\nOwner -> <@%s>\nCreated -> <t:%s:d> <t:%s:T>\nLastUserEdited -> <@%s>\nLastEdited -> <t:%s:d> <t:%s:T>\nisLocked -> %s\nisSuppressed -> %s\nTimes Used -> %s\n\n".formatted(new Object[]{trick.getTrickID(), trick.getType(), trick.getOwnerID(), trick.getCreated() / 1000L, trick.getCreated() / 1000L, trick.getLastUserEdited(), trick.getLastEdited() / 1000L, trick.getLastEdited() / 1000L, trick.isLocked(), trick.isSuppressed(), trick.getTimesUsed()});
            if (trick.getType() == TrickType.NORMAL) {
                details = (String)details + "Content: \n" + trick.getContent();
            } else if (trick.getType() == TrickType.ALIAS) {
                details = (String)details + "Alias -> " + trick.getAliasTarget();
            } else if (trick.getType() == TrickType.SCRIPT) {
                details = (String)details + "Script: \n" + trick.getScript();
            }
            ((MessageCreateAction)((MessageCreateAction)((MessageCreateAction)dMessage.apply(message.reply((CharSequence)details)).setSuppressedNotifications(true)).setSuppressEmbeds(true)).setAllowedMentions(List.of())).queue();
        } else if (type == TrickCMDType.SHOW) {
            if (!this.exists(trickID, guildID)) {
                dMessage.apply(message.reply((CharSequence)"Trick '%s' does not exist!".formatted(trickID))).queue();
                return CommandResult.PASS;
            }
            Trick trick = this.getTrick(trickID, guildID);
            this.useTrick(trick, message, (MessageChannel)message.getChannel(), guildID, args);
        } else {
            if (type == TrickCMDType.LIST) {
                int length;
                if (trickID != null) {
                    try {
                        length = Integer.parseInt(trickID);
                    }
                    catch (NumberFormatException e) {
                        length = 5;
                    }
                } else {
                    length = 5;
                }
                MessageChannelUnion channel = message.getChannel();
                if (!this.getTricksForGuild(guildID).isEmpty()) {
                    PagedList<String> tricks = this.createTricks(guildID, length);
                    channel.sendMessage((CharSequence)"Getting Tricks List...\n").queue(m -> {
                        this.PAGES.put(m.getId(), tricks);
                        TaskScheduler.getExecutor().schedule((Runnable)new RunnableTask(m, d -> this.removeTricksList((Message)d.get())), 10L, TimeUnit.MINUTES);
                        this.updateTrickListMessage(tricks, (Message)m, true);
                    });
                }
                return CommandResult.PASS;
            }
            if (type == TrickCMDType.LOCK) {
                if (!this.exists(trickID, guildID)) {
                    dMessage.apply(message.reply((CharSequence)"Trick '%s' does not exist!".formatted(trickID)));
                    return CommandResult.PASS;
                }
                Trick trick = this.getTrick(trickID, guildID);
                if (trick.getOwnerID() == member.getIdLong()) {
                    dMessage.apply(message.reply((CharSequence)((trick.isLocked() ? "Unlocked" : "Locked") + " Trick '%s'".formatted(trickID)))).queue();
                    trick.setLock(!trick.isLocked());
                    this.save(trick);
                } else {
                    dMessage.apply(message.reply((CharSequence)"Can only lock/unlock your own Tricks!")).queue();
                }
            } else if (type == TrickCMDType.TRANSFER) {
                // empty if block
            }
        }
        return CommandResult.PASS;
    }

    private void useTrick(Trick trick, Message message, MessageChannel channel, long guildID, Arguments args) {
        MessageSettings dMessage = this.plugin.getMessageSettings();
        TrickType type = trick.getType();
        if (type == TrickType.NORMAL) {
            dMessage.withButton((MessageCreateAction)dMessage.apply(channel.sendMessage((CharSequence)trick.getContent())).setSuppressEmbeds(trick.isSuppressed()), ((TrashButtonAction)MangoBotPlugin.ACTION_REGISTRY.get(TrashButtonAction.class)).createForUser(message.getAuthor())).queue();
            trick.use();
            this.save(trick);
        } else if (type == TrickType.ALIAS) {
            if (this.exists(trick.getAliasTarget(), guildID)) {
                Trick alias = this.getTrick(trick.getAliasTarget(), guildID);
                trick.use();
                this.useTrick(alias, message, channel, guildID, args);
            }
        } else if (type == TrickType.SCRIPT && message != null) {
            trick.use();
            String script = MarkdownSanitizer.sanitize((String)trick.getScript());
            this.SCRIPT_RUNNER.execute(script, message, channel, args.getArgs().length > 1 ? args.getFrom(2).split(" ") : new String[]{});
        }
    }

    public String commandId() {
        return "trick";
    }

    public List<String> commandAliases() {
        return CommandAlias.create((Object)this, (String[])new String[]{"tricks", "tr"});
    }

    public String usage() {
        return "## `!tricks`\n`-a` to add, `-e` to edit, `-s` to view source, `-r` to remove, `-l` to list.\n- To run a trick, use its ID as if it were another command. E.g.: `!drivers`\n- When adding or editing, you can optionally add the `-supress` arg to supress embeds in your trick's links.\n- When listing tricks, you can optionally specify how many you want per page.\n\n\n## Examples:\n\n## How to add tricks:\n`!tricks -a exampletrick -content this is an example trick`\n`!tricks -a exampletrickalias -alias exampletrick`\n\n## How to modify tricks:\n`!tricks -e exampletrick -suppress -content editing the trick. https://bing.com`\n`!tricks -e exampletrickalias -alias exampletrick`\n\n## How to lock/unlock a trick:\n`!tricks -lock exampletrick` // Do it again to unlock\n\n## How to show tricks:\n`!tricks -s exampletrick`\n\n## How to remove tricks:\n`!tricks -r exampletrick`\n\n## How to show a list of tricks:\n`!tricks -l 10`\n";
    }

    private void removeTricksList(Message message) {
        if (this.PAGES.containsKey(message.getId())) {
            ((MessageEditAction)message.editMessage((CharSequence)this.createTricksString(this.PAGES.get(message.getId()))).setComponents(new LayoutComponent[0])).queue();
            this.PAGES.remove(message.getId());
        }
    }

    private void updateTrickListMessage(PagedList<String> tricks, Message message, boolean addButtons, String buttonID) {
        switch (buttonID) {
            case "next": {
                tricks.next();
                break;
            }
            case "prev": {
                tricks.previous();
            }
        }
        String result = this.createTricksString(tricks);
        if (addButtons) {
            Button prev = Button.primary((String)"prev".formatted(message.getId()), (String)"previous");
            Button next = Button.primary((String)"next".formatted(message.getId()), (String)"next");
            ((MessageEditAction)message.editMessage((CharSequence)result).setActionRow(new ItemComponent[]{prev, next})).queue();
        } else {
            message.editMessage((CharSequence)result).queue();
        }
    }

    private void updateTrickListMessage(PagedList<String> tricks, Message message, boolean addButtons) {
        this.updateTrickListMessage(tricks, message, addButtons, "");
    }

    private String createTricksString(PagedList<String> tricks) {
        Object result = "List of Tricks (%s / %s) \r".formatted(tricks.getPage(), tricks.totalPages());
        PagedList.Page entries = tricks.current();
        int i = 0;
        for (String entry : (String[])entries.getEntries()) {
            result = (String)result + "%s: %s \r".formatted(++i, entry);
        }
        return result;
    }

    private PagedList<String> createTricks(long guildID, int entries) {
        PagedList tricks = new PagedList();
        Object[] LIST = this.getTricksForGuild(guildID).stream().map(Trick::getTrickID).toArray();
        tricks.rebuild((Object[])((String[])Arrays.copyOf(LIST, LIST.length, String[].class)), entries);
        return tricks;
    }

    public void onButton(DiscordEvent<ButtonInteractionEvent> event) {
        ButtonInteractionEvent interaction = (ButtonInteractionEvent)event.getInstance();
        Message message = interaction.getMessage();
        String ID = message.getId();
        if (this.PAGES.containsKey(ID)) {
            this.updateTrickListMessage(this.PAGES.get(ID), message, false, interaction.getButton().getId());
            interaction.getInteraction().deferEdit().queue();
        }
    }
}

