/*
 * Decompiled with CFR 0.152.
 */
package org.mangorage.mangobot.core;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UncheckedIOException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.time.temporal.TemporalAccessor;
import net.dv8tion.jda.api.entities.ISnowflake;
import net.dv8tion.jda.api.entities.Message;
import net.dv8tion.jda.api.events.message.MessageReceivedEvent;
import net.dv8tion.jda.api.utils.TimeUtil;
import org.mangorage.basicutils.LogHelper;
import org.mangorage.mangobotapi.core.commands.Arguments;
import org.mangorage.mangobotapi.core.commands.CommandPrefix;
import org.mangorage.mangobotapi.core.events.BasicCommandEvent;
import org.mangorage.mangobotapi.core.plugin.api.CorePlugin;
import org.mangorage.mboteventbus.base.Event;

public class Util {
    private static final boolean verbose = false;

    public static TemporalAccessor getTimestamp(ISnowflake iSnowflake) {
        return TimeUtil.getTimeCreated((ISnowflake)iSnowflake);
    }

    public static boolean handleMessage(CorePlugin plugin, MessageReceivedEvent event) {
        String Prefix = event.isFromGuild() ? CommandPrefix.getPrefix((String)event.getGuild().getId()) : plugin.getCommandPrefix();
        Message message = event.getMessage();
        String rawMessage = message.getContentRaw();
        if (rawMessage.length() > 1 && rawMessage.startsWith(Prefix)) {
            if (event.getAuthor().isBot()) {
                return true;
            }
            String[] command_pre = rawMessage.split(" ");
            String command = command_pre[0].replaceFirst(Prefix, "");
            Arguments arguments = Arguments.of((String[])Arguments.of((String[])command_pre).getFrom(1).split(" "));
            BasicCommandEvent commandEvent = new BasicCommandEvent(event.getMessage(), command, arguments);
            plugin.getCommandRegistry().postBasicCommand(commandEvent);
            if (!commandEvent.isHandled()) {
                plugin.getPluginBus().post((Event)commandEvent);
            }
            if (commandEvent.getException() != null) {
                plugin.getMessageSettings().apply(message.reply((CharSequence)"An Exception occurred while executing the command.\n%s\n".formatted(commandEvent.getException().getMessage()))).queue();
            } else if (commandEvent.isHandled()) {
                commandEvent.getCommandResult().accept(message);
            }
            return true;
        }
        return false;
    }

    public static Integer parseStringIntoInteger(String s) {
        Integer res = null;
        try {
            res = Integer.parseInt(s);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return res;
    }

    public static boolean copy(Path from, BasicFileAttributes a, Path target) {
        LogHelper.info((String)("Copy " + (a.isDirectory() ? "DIR " : "FILE") + " => " + String.valueOf(target)));
        try {
            if (a.isDirectory()) {
                Files.createDirectories(target, new FileAttribute[0]);
            } else if (a.isRegularFile()) {
                Files.copy(from, target, StandardCopyOption.REPLACE_EXISTING);
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        return true;
    }

    public static InputStream getFileInputStream(String fileUrl) {
        try {
            URL url = new URL(fileUrl);
            HttpURLConnection connection = (HttpURLConnection)url.openConnection();
            connection.setRequestMethod("GET");
            int responseCode = connection.getResponseCode();
            if (responseCode == 200) {
                int bytesRead;
                BufferedInputStream inputStream = new BufferedInputStream(connection.getInputStream());
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                byte[] buffer = new byte[1024];
                while ((bytesRead = ((InputStream)inputStream).read(buffer)) != -1) {
                    byteArrayOutputStream.write(buffer, 0, bytesRead);
                }
                byte[] byteArray = byteArrayOutputStream.toByteArray();
                byteArrayOutputStream.close();
                ((InputStream)inputStream).close();
                return new ByteArrayInputStream(byteArray);
            }
            throw new IOException("Server response code: " + responseCode);
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String getStringFromInputStream(InputStream inputStream) throws IOException {
        String line;
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
        String nl = System.getProperty("line.separator");
        StringBuilder stringBuilder = new StringBuilder();
        while ((line = bufferedReader.readLine()) != null) {
            stringBuilder.append(line + nl);
        }
        return stringBuilder.toString();
    }
}

