/*
 * Decompiled with CFR 0.152.
 */
package org.mangorage.mangobot.modules.basic.commands;

import java.util.List;
import net.dv8tion.jda.api.Permission;
import net.dv8tion.jda.api.entities.Guild;
import net.dv8tion.jda.api.entities.Member;
import net.dv8tion.jda.api.entities.Message;
import net.dv8tion.jda.api.requests.restaction.MessageCreateAction;
import org.jetbrains.annotations.NotNull;
import org.mangorage.mangobot.core.BotPermissions;
import org.mangorage.mangobotapi.core.commands.Arguments;
import org.mangorage.mangobotapi.core.commands.CommandResult;
import org.mangorage.mangobotapi.core.commands.IBasicCommand;
import org.mangorage.mangobotapi.core.plugin.api.CorePlugin;
import org.mangorage.mangobotapi.core.registry.permissions.BasicPermission;
import org.mangorage.mangobotapi.core.registry.permissions.PermissionRegistry;
import org.mangorage.mangobotapi.core.util.MessageSettings;

public class PermissionCommand
implements IBasicCommand {
    private final CorePlugin corePlugin;
    private final PermissionRegistry permissionRegistry;

    public PermissionCommand(CorePlugin corePlugin) {
        this.corePlugin = corePlugin;
        this.permissionRegistry = corePlugin.getPermissionRegistry();
    }

    @NotNull
    public CommandResult execute(Message message, Arguments args) {
        if (!message.isFromGuild()) {
            return CommandResult.GUILD_ONLY;
        }
        Guild guild = message.getGuild();
        Member member = message.getMember();
        if (member == null) {
            return CommandResult.FAIL;
        }
        if (!BotPermissions.PERMISSION_ADMIN.hasPermission(member)) {
            return CommandResult.NO_PERMISSION;
        }
        MessageSettings settings = this.corePlugin.getMessageSettings();
        String subcmd = args.get(0);
        String permId = args.get(1);
        String id = args.get(2);
        if (subcmd.equals("addPerm") || subcmd.equals("removePerm") || subcmd.equals("reset")) {
            try {
                Permission.valueOf((String)id);
            }
            catch (IllegalArgumentException e) {
                settings.apply(message.reply((CharSequence)"Discord Permission '%s' not found!".formatted(id))).queue();
                return CommandResult.PASS;
            }
        }
        if (subcmd.equals("addRole")) {
            if (this.permissionRegistry.getPermission(permId) == null) {
                settings.apply(message.reply((CharSequence)"Bot Permission '%s' not found!".formatted(permId))).queue();
                return CommandResult.PASS;
            }
            this.permissionRegistry.getPermission(permId).addRole(guild.getId(), id);
            return CommandResult.PASS;
        }
        if (subcmd.equals("removeRole")) {
            if (this.permissionRegistry.getPermission(permId) == null) {
                settings.apply(message.reply((CharSequence)"Bot Permission '%s' not found!".formatted(permId))).queue();
                return CommandResult.PASS;
            }
            this.permissionRegistry.getPermission(permId).removeRole(guild.getId(), id);
            return CommandResult.PASS;
        }
        if (subcmd.equals("addPerm")) {
            if (this.permissionRegistry.getPermission(permId) == null) {
                settings.apply(message.reply((CharSequence)"Bot Permission '%s' not found!".formatted(permId))).queue();
                return CommandResult.PASS;
            }
            this.permissionRegistry.getPermission(permId).addPermission(guild.getId(), Permission.valueOf((String)id));
            return CommandResult.PASS;
        }
        if (subcmd.equals("removePerm")) {
            if (this.permissionRegistry.getPermission(permId) == null) {
                settings.apply(message.reply((CharSequence)"Bot Permission '%s' not found!".formatted(permId))).queue();
                return CommandResult.PASS;
            }
            this.permissionRegistry.getPermission(permId).removePermission(guild.getId(), Permission.valueOf((String)id));
            return CommandResult.PASS;
        }
        if (subcmd.equals("info")) {
            if (this.permissionRegistry.getPermission(permId) == null) {
                settings.apply(message.reply((CharSequence)"Bot Permission '%s' not found!".formatted(permId))).queue();
                return CommandResult.PASS;
            }
            BasicPermission permission = this.permissionRegistry.getPermission(permId);
            ((MessageCreateAction)((MessageCreateAction)settings.apply(message.reply((CharSequence)permission.getInfo(guild))).setAllowedMentions(List.of())).setSuppressedNotifications(true)).queue();
            return CommandResult.PASS;
        }
        if (subcmd.equals("discordperms")) {
            StringBuilder builder = new StringBuilder();
            builder.append("All Discord Permissions:").append("\n\n");
            for (Permission perm2 : Permission.values()) {
                builder.append(perm2.getName()).append(" -> ").append(perm2).append("\n");
            }
            settings.apply(message.reply((CharSequence)builder.toString())).queue();
            return CommandResult.PASS;
        }
        if (subcmd.equals("list")) {
            StringBuilder list = new StringBuilder();
            list.append("Permissions:").append("\n\n");
            this.permissionRegistry.getPermissions().forEach(perm -> list.append((String)perm).append("\n"));
            settings.apply(message.reply((CharSequence)list.toString())).queue();
            return CommandResult.PASS;
        }
        if (subcmd.equals("reset")) {
            if (this.permissionRegistry.getPermission(permId) == null) {
                settings.apply(message.reply((CharSequence)"Bot Permission '%s' not found!".formatted(permId))).queue();
                return CommandResult.PASS;
            }
            this.permissionRegistry.getPermission(permId).reset(guild.getId());
            return CommandResult.PASS;
        }
        if (subcmd.equalsIgnoreCase("test")) {
            String userID = args.get(2);
            Member member2 = guild.getMemberById(userID);
            if (member2 == null) {
                return CommandResult.PASS;
            }
            boolean result = this.permissionRegistry.getPermission(permId).hasPermission(member2);
            message.reply((CharSequence)"Has Permission: %s".formatted(result)).queue();
            return CommandResult.PASS;
        }
        return CommandResult.FAIL;
    }

    public String commandId() {
        return "permission";
    }
}

