/*
 * Decompiled with CFR 0.152.
 */
package org.mangorage.mangobot.modules.mappings;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Mappings {
    public final Map<String, String> classes = new HashMap<String, String>();
    public final Map<String, String> defs = new HashMap<String, String>();
    public final Map<String, String> vars = new HashMap<String, String>();
    public final Map<String, String> params = new HashMap<String, String>();
    public Mappings reverse;

    public Mappings() {
    }

    public Mappings(InputStream pdme) {
        System.out.println("Parsing Mappings");
        BufferedReader reader = new BufferedReader(new InputStreamReader(pdme));
        int num = 0;
        try {
            String line;
            while ((line = reader.readLine()) != null) {
                String[] row_array = line.split("\\u00B6");
                if (num != 0) {
                    if (row_array[0].equals("Class")) {
                        this.classes.put(row_array[1], row_array[2]);
                    } else if (row_array[0].equals("Def")) {
                        this.defs.put(row_array[1], row_array[2]);
                    } else if (row_array[0].equals("Var")) {
                        this.vars.put(row_array[1], row_array[2]);
                    } else if (row_array[0].equals("Param")) {
                        this.params.put(row_array[3] + "_" + row_array[4], row_array[2]);
                    }
                }
                ++num;
            }
            reader.close();
        }
        catch (IOException e) {
            e.printStackTrace(System.out);
        }
        this.parseSubClasses();
        System.out.println("Getting reverse mappings");
        this.reverse();
    }

    public void reverse() {
        String[] divided;
        String des;
        Mappings rev = new Mappings();
        for (Map.Entry<String, String> def : this.defs.entrySet()) {
            CharSequence[] old_class_arr = Arrays.copyOfRange(def.getKey().split("\\."), 0, def.getKey().split("\\.").length - 1);
            String old_classname = String.join((CharSequence)".", old_class_arr);
            String new_classname = this.getClassMappedName(old_classname);
            des = this.renameClassesInMethodDescriptor("(" + def.getKey().split("\\(")[1]);
            divided = def.getKey().split("\\.");
            rev.defs.put(new_classname + "." + def.getValue() + des, divided[divided.length - 1].split("\\(")[0]);
        }
        for (Map.Entry<String, String> def : this.vars.entrySet()) {
            String old_classname = String.join((CharSequence)".", Arrays.copyOfRange(def.getKey().split("\\."), 0, def.getKey().split("\\.").length - 1));
            String new_classname = this.getClassMappedName(old_classname);
            String old_des = def.getKey().split(":")[1];
            des = this.renameClassesInFieldDescriptor(old_des);
            divided = def.getKey().split("\\.");
            if (divided[divided.length - 1].startsWith("$")) {
                // empty if block
            }
            rev.vars.put(new_classname + "." + def.getValue() + ":" + des, divided[divided.length - 1].split(":")[0]);
        }
        for (Map.Entry<String, String> def : this.classes.entrySet()) {
            rev.classes.put(def.getValue(), def.getKey());
        }
        this.reverse = rev;
    }

    public String renameClassesInMethodDescriptor(String methodDescriptor) {
        String updatedDescriptor = methodDescriptor;
        Pattern classPattern = Pattern.compile("L([^;]+);");
        Matcher classMatcher = classPattern.matcher(methodDescriptor);
        while (classMatcher.find()) {
            String className = classMatcher.group(1);
            String updatedClassName = this.updateClassName(className);
            updatedDescriptor = updatedDescriptor.replace(className, updatedClassName);
        }
        return updatedDescriptor;
    }

    private String updateClassName(String className) {
        return this.getClassMappedName(className.replace("/", ".")).replace(".", "/");
    }

    public String getClassMappedName(String original) {
        if (this.classes.get(original) != null) {
            return this.classes.get(original);
        }
        return original;
    }

    public String getClassUnMappedName(String mapped) {
        for (Map.Entry<String, String> entry : this.classes.entrySet()) {
            if (!mapped.equals(entry.getValue())) continue;
            return entry.getKey();
        }
        return mapped;
    }

    public String getDefMappedName(String original) {
        return this.defs.getOrDefault(original, original.split("\\.")[original.split("\\.").length - 1].split("\\(")[0]);
    }

    public String getVarMappedName(String original) {
        return this.vars.getOrDefault(original, original.split("\\.")[original.split("\\.").length - 1].split(":")[0]);
    }

    public String getParamMappedName(String method_with_descriptor, int location) {
        if (this.defs.get(method_with_descriptor + "_" + location) != null) {
            return this.defs.get(method_with_descriptor + "_" + location);
        }
        return method_with_descriptor;
    }

    public void parseSubClasses() {
        for (Map.Entry<String, String> entry : this.classes.entrySet()) {
            if (!entry.getKey().contains("$")) continue;
            entry.setValue(this.parseSubClass(entry.getKey()));
        }
    }

    public String parseSubClass(String original_classname) {
        String new_name = this.getClassMappedName(original_classname);
        if (new_name.contains("$")) {
            return new_name;
        }
        String[] sub_arr = original_classname.split("\\$");
        CharSequence[] subarray = (String[])Arrays.copyOfRange(sub_arr, 0, sub_arr.length - 1).clone();
        String root_class = this.getClassMappedName(String.join((CharSequence)"$", subarray));
        if (root_class.contains("$")) {
            root_class = this.parseSubClass(root_class);
        }
        String sub_class = new_name;
        return root_class + "$" + sub_class;
    }

    public String parseSubClassUnmapped(String unmapped) {
        String[] sub_arr = unmapped.split("\\$");
        CharSequence[] subarray = (String[])Arrays.copyOfRange(sub_arr, 0, sub_arr.length - 1).clone();
        String root_class = this.getClassMappedName(String.join((CharSequence)"$", subarray));
        String sub_class = this.getClassMappedName(unmapped);
        return root_class + "$" + sub_class;
    }

    public void addClass(String original, String mapped) {
        this.classes.put(original, mapped);
    }

    public void addDef(String original, String mapped) {
        this.defs.put(original, mapped);
    }

    public void addVar(String original, String mapped) {
        this.vars.put(original, mapped);
    }

    public void addParam(String original, String mapped) {
        this.params.put(original, mapped);
    }

    public String renameClassesInFieldDescriptor(String old_desc) {
        if (!old_desc.contains("L")) {
            return old_desc;
        }
        String[] parts = old_desc.split("L");
        String[] classNameParts = parts[1].split(";");
        String old_clazz = classNameParts[0].replaceAll("/", ".");
        String clazz = this.getClassMappedName(old_clazz).replaceAll("\\.", "/");
        String desc = old_desc.replaceAll(old_clazz.replaceAll("\\.", "/"), clazz);
        return desc;
    }
}

