/*
 * Decompiled with CFR 0.152.
 */
package org.mangorage.mangobot.core;

import net.dv8tion.jda.api.events.guild.voice.GuildVoiceUpdateEvent;
import net.dv8tion.jda.api.events.interaction.ModalInteractionEvent;
import net.dv8tion.jda.api.events.interaction.command.CommandAutoCompleteInteractionEvent;
import net.dv8tion.jda.api.events.interaction.command.SlashCommandInteractionEvent;
import net.dv8tion.jda.api.events.interaction.component.ButtonInteractionEvent;
import net.dv8tion.jda.api.events.interaction.component.StringSelectInteractionEvent;
import net.dv8tion.jda.api.events.message.MessageDeleteEvent;
import net.dv8tion.jda.api.events.message.MessageReceivedEvent;
import net.dv8tion.jda.api.events.message.MessageUpdateEvent;
import net.dv8tion.jda.api.events.message.react.MessageReactionAddEvent;
import net.dv8tion.jda.api.events.session.SessionDisconnectEvent;
import net.dv8tion.jda.api.events.session.SessionResumeEvent;
import net.dv8tion.jda.api.hooks.SubscribeEvent;
import org.mangorage.basicutils.LogHelper;
import org.mangorage.jdautils.WatcherManager;
import org.mangorage.mangobot.core.Util;
import org.mangorage.mangobotapi.core.events.discord.DButtonInteractionEvent;
import org.mangorage.mangobotapi.core.events.discord.DMessageDeleteEvent;
import org.mangorage.mangobotapi.core.events.discord.DMessageReceivedEvent;
import org.mangorage.mangobotapi.core.events.discord.DMessageUpdateEvent;
import org.mangorage.mangobotapi.core.events.discord.DModalInteractionEvent;
import org.mangorage.mangobotapi.core.events.discord.DReactionEvent;
import org.mangorage.mangobotapi.core.events.discord.DStringSelectInteractionEvent;
import org.mangorage.mangobotapi.core.events.discord.DVoiceUpdateEvent;
import org.mangorage.mangobotapi.core.plugin.api.CorePlugin;
import org.mangorage.mboteventbus.base.Event;
import org.mangorage.mboteventbus.impl.IEventBus;

public class BotEventListener {
    private final CorePlugin plugin;
    private final IEventBus bus;

    public BotEventListener(CorePlugin plugin) {
        this.plugin = plugin;
        this.bus = plugin.getPluginBus();
    }

    @SubscribeEvent
    public void modalInteraction(ModalInteractionEvent event) {
        this.bus.post((Event)new DModalInteractionEvent(event));
    }

    @SubscribeEvent
    public void messageRecieved(MessageReceivedEvent event) {
        boolean isCommand = Util.handleMessage(this.plugin, event);
        this.bus.post((Event)new DMessageReceivedEvent(event, isCommand));
    }

    @SubscribeEvent
    public void onSlashCommand(SlashCommandInteractionEvent event) {
        WatcherManager.onCommandEvent((SlashCommandInteractionEvent)event);
    }

    @SubscribeEvent
    public void onSlashAuto(CommandAutoCompleteInteractionEvent event) {
        WatcherManager.onCommandAutoCompleteEvent((CommandAutoCompleteInteractionEvent)event);
    }

    @SubscribeEvent
    public void sessionResumeEvent(SessionResumeEvent event) {
        LogHelper.info((String)"Bot resumed Session...");
    }

    @SubscribeEvent
    public void sessionDisconnectEvent(SessionDisconnectEvent event) {
        LogHelper.info((String)"Bot disconnected from Session...");
    }

    @SubscribeEvent
    public void messageReact(MessageReactionAddEvent event) {
        this.bus.post((Event)new DReactionEvent(event));
    }

    @SubscribeEvent
    public void interact(ButtonInteractionEvent event) {
        this.bus.post((Event)new DButtonInteractionEvent(event));
    }

    @SubscribeEvent
    public void messageUpdate(MessageUpdateEvent event) {
        this.bus.post((Event)new DMessageUpdateEvent(event));
    }

    @SubscribeEvent
    public void messageDelete(MessageDeleteEvent event) {
        this.bus.post((Event)new DMessageDeleteEvent(event));
    }

    @SubscribeEvent
    public void messageStringSelect(StringSelectInteractionEvent event) {
        this.bus.post((Event)new DStringSelectInteractionEvent(event));
    }

    @SubscribeEvent
    public void voiceUpdate(GuildVoiceUpdateEvent event) {
        this.bus.post((Event)new DVoiceUpdateEvent(event));
    }
}

