/*
 * Decompiled with CFR 0.152.
 */
package org.mangorage.mangobot.modules.basic.commands;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.concurrent.atomic.AtomicReference;
import net.dv8tion.jda.api.entities.Message;
import org.jetbrains.annotations.NotNull;
import org.mangorage.mangobotapi.core.commands.Arguments;
import org.mangorage.mangobotapi.core.commands.CommandResult;
import org.mangorage.mangobotapi.core.commands.IBasicCommand;
import org.mangorage.mangobotapi.core.data.DataHandler;
import org.mangorage.mangobotapi.core.plugin.api.CorePlugin;
import org.mangorage.mangobotapi.core.util.MessageSettings;

public class VersionCommand
implements IBasicCommand {
    private static final AtomicReference<Version> VERSION = new AtomicReference();
    private static final DataHandler<Version> VERSION_DATA_HANDLER = DataHandler.create(VERSION::set, Version.class, (String)"installer/", (DataHandler.Properties)DataHandler.Properties.create().setFileName("version.json").useDefaultFileNamePredicate());
    private final CorePlugin corePlugin;

    public static void init() {
        VERSION_DATA_HANDLER.loadAll();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String findVersion(String key, String filePath) {
        try (BufferedReader reader = new BufferedReader(new FileReader(filePath));){
            String line;
            String[] parts;
            do {
                if ((line = reader.readLine()) == null) return "Undefined Version";
            } while ((parts = line.split("=")).length != 2 || !parts[0].trim().equals(key));
            String string = parts[1].trim();
            return string;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return "Undefined Version";
    }

    public static String getVersion() {
        if (VERSION.get() == null) {
            VERSION.set(new Version(VersionCommand.findVersion("mangobotplugin.jar", "installer/installed.txt")));
        }
        return VERSION.get().version();
    }

    public VersionCommand(CorePlugin corePlugin) {
        this.corePlugin = corePlugin;
    }

    @NotNull
    public CommandResult execute(Message message, Arguments args) {
        MessageSettings settings = this.corePlugin.getMessageSettings();
        settings.apply(message.reply((CharSequence)("Bot is running on Version: " + VERSION.get().version()))).queue();
        return CommandResult.PASS;
    }

    public String commandId() {
        return "version";
    }

    public String description() {
        return "Tells you what version the bot is running on.";
    }

    public record Version(String version) {
    }
}

