/*
 * Decompiled with CFR 0.152.
 */
package org.mangorage.mangobotcore.plugin.internal.dependency;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.mangorage.mangobotcore.plugin.internal.dependency.DependencyImpl;
import org.mangorage.mangobotcore.plugin.internal.dependency.Library;

public final class LibraryManager<T> {
    private final HashMap<String, Library<T>> libraries = new HashMap();

    public void addLibrary(String id, T value) {
        this.libraries.put(id, new Library<T>(value));
    }

    public void addDependenciesForLibrary(String id, List<DependencyImpl> dependencies) {
        Library<T> library = this.libraries.get(id);
        if (library != null) {
            for (DependencyImpl dependency : dependencies) {
                Library<T> dependencyLibrary = this.libraries.get(dependency.id());
                if (dependencyLibrary == null) {
                    switch (dependency.type()) {
                        case REQUIRED: {
                            throw new IllegalStateException("Failed to find Dependency %s for %s".formatted(dependency.id(), id));
                        }
                    }
                    continue;
                }
                dependencyLibrary.incrementPriority();
                library.addDependency(dependency.id());
            }
        }
    }

    public Collection<Library<T>> getLibraries() {
        return this.libraries.values();
    }

    public List<Library<T>> getLibrariesInOrder() {
        return this.libraries.values().stream().sorted().toList();
    }
}

