/*
 * Decompiled with CFR 0.152.
 */
package org.mangorage.commonutils.jda.slash.command.watcher;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import net.dv8tion.jda.api.events.Event;
import net.dv8tion.jda.internal.utils.Checks;
import org.jetbrains.annotations.NotNull;
import org.mangorage.commonutils.jda.slash.command.watcher.WatcherManager;
import org.mangorage.commonutils.jda.slash.component.Component;

public final class EventWatcher<E extends Event> {
    private final Component component;
    private final Class<E> eventClass;
    private final List<Function<E, Boolean>> conditions = new ArrayList<Function<E, Boolean>>();
    private Listener<E> listener;
    private long expireTime = -1L;
    private boolean singleUse = false;

    public EventWatcher(Component component, Class<E> eventClass) {
        this.component = component;
        this.eventClass = eventClass;
    }

    public EventWatcher(Component component, Class<E> eventClass, boolean singleUse) {
        this(component, eventClass);
        this.singleUse = singleUse;
    }

    public EventWatcher<E> setListener(Listener<E> listener) {
        this.listener = listener;
        WatcherManager.addWatcher(this);
        return this;
    }

    public EventWatcher<E> setListener(Listener<E> listener, int expireAfter, @NotNull TimeUnit unit) {
        this.expireTime = System.currentTimeMillis() + unit.toMillis(expireAfter);
        this.setListener(listener);
        return this;
    }

    public EventWatcher<E> addCondition(@NotNull Function<E, Boolean> condition) {
        Checks.notNull(condition, (String)"Condition");
        Checks.notNull(this.eventClass, (String)"Event class");
        this.conditions.add(condition);
        return this;
    }

    public EventWatcher<E> addConditions(@NotNull List<Function<E, Boolean>> conditions) {
        Checks.notNull(conditions, (String)"Conditions");
        conditions.forEach(this::addCondition);
        return this;
    }

    public Listener<E> getListener() {
        return this.listener;
    }

    public void destroy() {
        this.listener = null;
        this.expireTime = -1L;
        WatcherManager.removeWatcher(this);
    }

    void onEvent(Event rawEvent) {
        if (this.expired()) {
            this.destroy();
            return;
        }
        if (this.listener != null && rawEvent.getClass().equals(this.eventClass)) {
            Event event = rawEvent;
            boolean conditionsMet = this.conditions.stream().allMatch(condition -> (Boolean)condition.apply(event));
            if (!conditionsMet) {
                return;
            }
            this.listener.onEvent(event);
            if (this.singleUse) {
                this.destroy();
            }
        }
    }

    public Component getComponent() {
        return this.component;
    }

    public boolean expired() {
        return this.expireTime != -1L && System.currentTimeMillis() > this.expireTime;
    }

    public static interface Listener<E> {
        public void onEvent(E var1);
    }
}

