/*
 * Decompiled with CFR 0.152.
 */
package org.mangorage.mangobotcore.plugin.internal.dependency;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.mangorage.mangobotcore.plugin.api.Dependency;
import org.mangorage.mangobotcore.plugin.internal.dependency.Library;

public final class LibraryManager<T> {
    private final HashMap<String, Library<T>> libraries = new HashMap();

    public void addLibrary(String id, T value) {
        this.libraries.put(id, new Library<T>(value));
    }

    public void addDependenciesForLibrary(String id, List<? extends Dependency> dependencies) {
        Library<T> library = this.libraries.get(id);
        if (library != null) {
            for (Dependency dependency : dependencies) {
                Library<T> dependencyLibrary = this.libraries.get(dependency.getId());
                if (dependencyLibrary == null) {
                    switch (dependency.getType()) {
                        case REQUIRED: {
                            throw new IllegalStateException("Failed to find Dependency %s for %s".formatted(dependency.getId(), id));
                        }
                    }
                    continue;
                }
                dependencyLibrary.incrementPriority();
                library.addDependency(dependency.getId());
            }
        }
    }

    public Collection<Library<T>> getLibraries() {
        return this.libraries.values();
    }

    public List<Library<T>> getLibrariesInOrder() {
        return this.libraries.values().stream().sorted().toList();
    }
}

