/*
 * Decompiled with CFR 0.152.
 */
package org.mangorage.mangobotcore.config.internal;

import org.mangorage.mangobotcore.config.api.IConfig;
import org.mangorage.mangobotcore.config.api.IConfigSetting;
import org.mangorage.mangobotcore.config.api.IConfigType;

public final class ConfigSettingImpl<T>
implements IConfigSetting<T> {
    private final IConfig config;
    private final String id;
    private final IConfigType<T> configType;
    private final T defaultValue;

    public ConfigSettingImpl(IConfig config, String id, IConfigType<T> configType, T defaultValue) {
        this.config = config;
        this.id = id;
        this.configType = configType;
        this.defaultValue = defaultValue;
    }

    @Override
    public T get() {
        T result = this.configType.get(this.config.get(this.id));
        return result != null ? result : this.defaultValue;
    }

    @Override
    public void set(T value) {
        this.config.set(this.id, this.configType.get(value));
        this.config.save();
    }
}

