/*
 * Decompiled with CFR 0.152.
 */
package org.mangorage.mangobotcore.config.internal;

import java.io.BufferedWriter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.attribute.FileAttribute;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Pattern;
import org.mangorage.commonutils.misc.FileMonitor;
import org.mangorage.mangobotcore.config.api.IConfig;

public final class ConfigImpl
implements IConfig {
    private static final Pattern CONFIG_REGEX = Pattern.compile("^\\s*([\\w.\\-]+)\\s*(=)\\s*(['][^']*[']|[\"][^\"]*[\"]|[^#]*)?\\s*(#.*)?$");
    private final Path filePath;
    private final Map<String, String> entries = new ConcurrentHashMap<String, String>();

    public ConfigImpl(Path filePath) {
        this(filePath, false);
    }

    public ConfigImpl(Path filePath, boolean autoReload) {
        this.filePath = filePath;
        try {
            this.load();
            if (autoReload) {
                FileMonitor.getMonitor().register(filePath, kind -> {
                    if (kind == StandardWatchEventKinds.ENTRY_MODIFY) {
                        this.reload();
                    }
                }, StandardWatchEventKinds.ENTRY_MODIFY);
            }
        }
        catch (IOException e) {
            throw new IllegalStateException("Unable to load Config...");
        }
    }

    private void load() throws IOException {
        if (Files.exists(this.filePath, new LinkOption[0])) {
            Files.readAllLines(this.filePath).forEach(e -> {
                if (CONFIG_REGEX.matcher((CharSequence)e).matches()) {
                    String[] a = e.split("=", 2);
                    this.entries.put(a[0], a[1]);
                }
            });
        } else {
            Files.createDirectories(this.filePath.getParent(), new FileAttribute[0]);
            Files.createFile(this.filePath, new FileAttribute[0]);
        }
    }

    @Override
    public void reload() {
        this.entries.clear();
        try {
            this.load();
        }
        catch (IOException e) {
            throw new IllegalStateException("Unable to reload config...");
        }
    }

    @Override
    public String get(String ID) {
        return this.entries.get(ID);
    }

    @Override
    public void set(String ID, String value) {
        this.entries.put(ID, value);
    }

    @Override
    public Path getFilePath() {
        return this.filePath;
    }

    @Override
    public void save() {
        try {
            BufferedWriter writer = Files.newBufferedWriter(this.filePath, new OpenOption[0]);
            this.entries.forEach((key, value) -> {
                String line = "%s=%s".formatted(key, value);
                try {
                    writer.write(line);
                    writer.newLine();
                }
                catch (IOException ex) {
                    throw new RuntimeException(ex);
                }
            });
            writer.flush();
            writer.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

