/*
 * Decompiled with CFR 0.152.
 */
package org.mangorage.mixin.core;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.mangorage.bootstrap.api.loader.MangoLoader;
import org.mangorage.mixin.MixinContainer;
import org.mangorage.mixin.MixinLogger;
import org.mangorage.mixin.transformer.MangoBotTransformer;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.tree.ClassNode;
import org.spongepowered.asm.launch.platform.container.IContainerHandle;
import org.spongepowered.asm.logging.ILogger;
import org.spongepowered.asm.mixin.MixinEnvironment;
import org.spongepowered.asm.mixin.transformer.IMixinTransformerFactory;
import org.spongepowered.asm.service.IClassBytecodeProvider;
import org.spongepowered.asm.service.IClassProvider;
import org.spongepowered.asm.service.IClassTracker;
import org.spongepowered.asm.service.IMixinAuditTrail;
import org.spongepowered.asm.service.IMixinInternal;
import org.spongepowered.asm.service.IMixinService;
import org.spongepowered.asm.service.ITransformer;
import org.spongepowered.asm.service.ITransformerProvider;
import org.spongepowered.asm.transformers.MixinClassReader;
import org.spongepowered.asm.util.ReEntranceLock;

public final class MixinServiceMangoBot
implements IMixinService,
IClassProvider,
IClassBytecodeProvider,
ITransformerProvider,
IClassTracker {
    private final ReEntranceLock lock = new ReEntranceLock(1);
    private final MixinContainer container = new MixinContainer("mangobot");

    public String getName() {
        return "MangoBotMixinService";
    }

    public boolean isValid() {
        return true;
    }

    public void prepare() {
    }

    public MixinEnvironment.Phase getInitialPhase() {
        return MixinEnvironment.Phase.PREINIT;
    }

    public void offer(IMixinInternal iMixinInternal) {
        if (iMixinInternal instanceof IMixinTransformerFactory) {
            IMixinTransformerFactory factory = (IMixinTransformerFactory)iMixinInternal;
            MangoBotTransformer.getInstance().set(factory);
        }
    }

    public void init() {
    }

    public void beginPhase() {
    }

    public void checkEnv(Object o) {
    }

    public ReEntranceLock getReEntranceLock() {
        return this.lock;
    }

    public IClassProvider getClassProvider() {
        return this;
    }

    public IClassBytecodeProvider getBytecodeProvider() {
        return this;
    }

    public ITransformerProvider getTransformerProvider() {
        return this;
    }

    public IClassTracker getClassTracker() {
        return this;
    }

    public IMixinAuditTrail getAuditTrail() {
        return null;
    }

    public Collection<String> getPlatformAgents() {
        return List.of();
    }

    public IContainerHandle getPrimaryContainer() {
        return this.container;
    }

    public Collection<IContainerHandle> getMixinContainers() {
        return List.of();
    }

    public InputStream getResourceAsStream(String s) {
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        return loader.getResourceAsStream(s);
    }

    public String getSideName() {
        return MixinEnvironment.Side.SERVER.name();
    }

    public MixinEnvironment.CompatibilityLevel getMinCompatibilityLevel() {
        return MixinEnvironment.CompatibilityLevel.JAVA_8;
    }

    public MixinEnvironment.CompatibilityLevel getMaxCompatibilityLevel() {
        return MixinEnvironment.CompatibilityLevel.JAVA_22;
    }

    public ILogger getLogger(String s) {
        return MixinLogger.get(s);
    }

    public URL[] getClassPath() {
        return new URL[0];
    }

    @NotNull
    public Class<?> findClass(@NotNull String name) throws ClassNotFoundException {
        return Class.forName(name, true, Thread.currentThread().getContextClassLoader());
    }

    @NotNull
    public Class<?> findClass(@NotNull String name, boolean initialize) throws ClassNotFoundException {
        return Class.forName(name, initialize, Thread.currentThread().getContextClassLoader());
    }

    @NotNull
    public Class<?> findAgentClass(@NotNull String name, boolean initialize) throws ClassNotFoundException {
        return Class.forName(name, initialize, Thread.currentThread().getContextClassLoader());
    }

    @NotNull
    public ClassNode getClassNode(@NotNull String name) throws ClassNotFoundException, IOException {
        return this.getClassNode(name, true);
    }

    @NotNull
    public ClassNode getClassNode(@NotNull String name, boolean runTransformers) throws ClassNotFoundException, IOException {
        return this.getClassNode(name, runTransformers, 0);
    }

    @NotNull
    public ClassNode getClassNode(@NotNull String name, boolean runTransformers, int readerFlags) throws ClassNotFoundException, IOException {
        if (!runTransformers) {
            throw new IllegalStateException("ClassNodes must always be provided transformed!");
        }
        MangoLoader loader = (MangoLoader)Thread.currentThread().getContextClassLoader();
        String canonicalName = name.replace('/', '.');
        String internalName = name.replace('.', '/');
        byte[] classBytes = loader.getClassBytes(canonicalName);
        return this.classNode(canonicalName, internalName, classBytes, readerFlags);
    }

    @NotNull
    public ClassNode classNode(@NotNull String canonicalName, @NotNull String internalName, byte @NotNull [] input, int readerFlags) throws ClassNotFoundException {
        if (input.length != 0) {
            ClassNode node = new ClassNode(589824);
            MixinClassReader reader = new MixinClassReader(input, canonicalName);
            reader.accept((ClassVisitor)node, readerFlags);
            return node;
        }
        throw new ClassNotFoundException(canonicalName);
    }

    public static ClassNode getClassNode(byte[] classBytes) {
        ClassReader reader = new ClassReader(classBytes);
        ClassNode classNode = new ClassNode();
        reader.accept((ClassVisitor)classNode, 0);
        return classNode;
    }

    public void registerInvalidClass(String s) {
    }

    public boolean isClassLoaded(String name) {
        MangoLoader loader = (MangoLoader)Thread.currentThread().getContextClassLoader();
        return loader.hasClass(name);
    }

    public String getClassRestrictions(String s) {
        return "";
    }

    public Collection<ITransformer> getTransformers() {
        return List.of();
    }

    public Collection<ITransformer> getDelegatedTransformers() {
        return List.of();
    }

    public void addTransformerExclusion(String s) {
    }
}

