/*
 * Decompiled with CFR 0.152.
 */
package org.mangorage.mixin;

import org.mangorage.bootstrap.api.transformer.IClassTransformer;
import org.mangorage.bootstrap.api.transformer.TransformResult;
import org.mangorage.bootstrap.api.transformer.TransformerFlag;
import org.mangorage.mixin.SpongeMixinImpl;
import org.mangorage.mixin.transformer.MangoBotTransformer;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.tree.ClassNode;
import org.spongepowered.asm.mixin.MixinEnvironment;
import org.spongepowered.asm.mixin.transformer.IMixinTransformer;

public class SpongeMixinTransformer
implements IClassTransformer {
    public SpongeMixinTransformer() {
        SpongeMixinImpl.load();
    }

    public static byte[] getClassBytesFromNode(ClassNode classNode) {
        ClassWriter writer = new ClassWriter(3);
        classNode.accept((ClassVisitor)writer);
        return writer.toByteArray();
    }

    public TransformResult transform(String name, byte[] bytes) {
        byte[] transformed;
        IMixinTransformer transformer = MangoBotTransformer.getInstance().getTransformer();
        if (name.startsWith("org.mangorage.mangobotcore.ExampleThing") && !SpongeMixinTransformer.areByteArraysEqual(transformed = transformer.transformClass(MixinEnvironment.getCurrentEnvironment(), name, bytes), bytes)) {
            return new TransformResult(transformed, TransformerFlag.FULL_REWRITE);
        }
        return new TransformResult(null, TransformerFlag.NO_REWRITE);
    }

    public static boolean areByteArraysEqual(byte[] a, byte[] b) {
        if (a == b) {
            return true;
        }
        if (a == null || b == null) {
            return false;
        }
        if (a.length != b.length) {
            return false;
        }
        for (int i = 0; i < a.length; ++i) {
            if (a[i] == b[i]) continue;
            return false;
        }
        return true;
    }

    public String getName() {
        return "mixin";
    }
}

