/*
 * Decompiled with CFR 0.152.
 */
package org.mangorage.mixin;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.spongepowered.asm.logging.ILogger;
import org.spongepowered.asm.logging.Level;
import org.spongepowered.asm.logging.LoggerAdapterAbstract;

public class MixinLogger
extends LoggerAdapterAbstract {
    private static final Map<String, ILogger> LOGGER_MAP = new ConcurrentHashMap<String, ILogger>();

    public static ILogger get(String name) {
        return LOGGER_MAP.computeIfAbsent(name, MixinLogger::new);
    }

    protected MixinLogger(String id) {
        super(id);
    }

    public String getType() {
        return "MangoBot Mixin Logger";
    }

    public void catching(Level level, Throwable throwable) {
        throwable.printStackTrace();
    }

    public static void print(String message, Object ... args) {
        for (Object arg : args) {
            message = message.replaceFirst("\\{}", arg == null ? "null" : arg.toString());
        }
        System.out.println(message);
    }

    public void log(Level level, String s, Object ... objects) {
        MixinLogger.print(s, objects);
    }

    public void log(Level level, String s, Throwable throwable) {
        System.out.println(s);
    }

    public <T extends Throwable> T throwing(T t) {
        System.out.println(t);
        t.printStackTrace();
        return null;
    }
}

