/*
 * Decompiled with CFR 0.152.
 */
package org.mangorage.commonutils.jda.slash.command.watcher;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.dv8tion.jda.api.entities.User;
import net.dv8tion.jda.api.events.Event;
import net.dv8tion.jda.api.events.interaction.command.CommandAutoCompleteInteractionEvent;
import net.dv8tion.jda.api.events.interaction.command.GenericContextInteractionEvent;
import net.dv8tion.jda.api.events.interaction.command.SlashCommandInteractionEvent;
import net.dv8tion.jda.api.events.message.MessageDeleteEvent;
import net.dv8tion.jda.api.events.message.MessageReceivedEvent;
import net.dv8tion.jda.api.events.message.react.GenericMessageReactionEvent;
import org.jetbrains.annotations.NotNull;
import org.mangorage.commonutils.jda.slash.command.CommandComponent;
import org.mangorage.commonutils.jda.slash.command.OptionComponent;
import org.mangorage.commonutils.jda.slash.command.watcher.EventWatcher;
import org.mangorage.commonutils.jda.slash.command.watcher.MessageFilterEvent;
import org.mangorage.commonutils.jda.slash.component.Component;
import org.mangorage.commonutils.jda.slash.component.SendableComponent;
import org.mangorage.commonutils.jda.slash.component.interact.SmartReaction;
import org.mangorage.commonutils.jda.slash.message.Filter;
import org.mangorage.commonutils.jda.slash.message.MessageComponent;

public final class WatcherManager {
    private static final List<EventWatcher<? extends Event>> watchers = new ArrayList<EventWatcher<? extends Event>>();
    private static final List<EventWatcher<? extends Event>> pendingRemoval = new ArrayList<EventWatcher<? extends Event>>();

    private WatcherManager() {
    }

    static void addWatcher(EventWatcher<? extends Event> watcher) {
        if (!watchers.contains(watcher)) {
            watchers.add(watcher);
        }
    }

    static void removeWatcher(EventWatcher<? extends Event> watcher) {
        pendingRemoval.add(watcher);
    }

    public static void cleanup() {
        ArrayList<EventWatcher> toRemove = new ArrayList<EventWatcher>(watchers.stream().filter(EventWatcher::expired).toList());
        toRemove.forEach(EventWatcher::destroy);
        watchers.removeAll(pendingRemoval);
        pendingRemoval.clear();
    }

    public static void cleanup(MessageDeleteEvent event) {
        ArrayList toRemove = new ArrayList();
        watchers.stream().filter(watcher -> watcher.getComponent() instanceof SendableComponent).filter(watcher -> ((SendableComponent)watcher.getComponent()).isSent()).filter(watcher -> ((SendableComponent)watcher.getComponent()).getMessageId() == event.getMessageIdLong()).filter(watcher -> ((SendableComponent)watcher.getComponent()).getGuild().equals((Object)event.getGuild())).forEach(watcher -> toRemove.add((SendableComponent)watcher.getComponent()));
        toRemove.forEach(SendableComponent::remove);
        WatcherManager.cleanup();
    }

    public static void onMessageEvent(@NotNull MessageReceivedEvent event) {
        watchers.stream().filter(watcher -> watcher.getComponent() instanceof MessageComponent).forEach(watcher -> watcher.onEvent((Event)event));
    }

    public static void onFilterTrigger(@NotNull List<Filter> triggeredFilters, MessageReceivedEvent event) {
        for (Filter triggeredFilter : triggeredFilters) {
            watchers.stream().filter(watcher -> watcher.getComponent() instanceof MessageComponent).filter(watcher -> ((MessageComponent)watcher.getComponent()).isFilter()).filter(watcher -> Objects.equals(((MessageComponent)watcher.getComponent()).getFilterName(), triggeredFilter.getName())).forEach(watcher -> watcher.onEvent((Event)MessageFilterEvent.of(triggeredFilter, event)));
        }
    }

    public static void onCommandEvent(@NotNull SlashCommandInteractionEvent event) {
        watchers.stream().filter(watcher -> watcher.getComponent() instanceof CommandComponent).filter(watcher -> watcher.getComponent().getName().equals(event.getFullCommandName()) || ((CommandComponent)watcher.getComponent()).getAliases().contains(event.getFullCommandName())).findFirst().ifPresent(watcher -> watcher.onEvent((Event)event));
    }

    public static void onCommandAutoCompleteEvent(@NotNull CommandAutoCompleteInteractionEvent event) {
        String commandAndOption = event.getFullCommandName() + " " + event.getFocusedOption().getName();
        watchers.stream().filter(watcher -> watcher.getComponent() instanceof OptionComponent).filter(watcher -> watcher.getComponent().getName().equals(commandAndOption)).findFirst().ifPresent(watcher -> watcher.onEvent((Event)event));
    }

    public static void onContextEvent(GenericContextInteractionEvent<?> event) {
        watchers.stream().filter(watcher -> watcher.getComponent() instanceof CommandComponent).filter(watcher -> watcher.getComponent().getName().equals(event.getName())).findFirst().ifPresent(watcher -> watcher.onEvent((Event)event));
    }

    public static void onInteractionEvent(String componentID, Event event) {
        watchers.stream().filter(watcher -> watcher.getComponent().getUuid() != null).filter(watcher -> watcher.getComponent().getUuid().toString().equals(componentID)).findFirst().ifPresent(watcher -> watcher.onEvent(event));
    }

    public static void onReactionEvent(@NotNull GenericMessageReactionEvent event) {
        if (((User)event.retrieveUser().complete()).isBot()) {
            return;
        }
        watchers.stream().filter(watcher -> watcher.getComponent() instanceof SmartReaction).filter(watcher -> watcher.getComponent().getUuid() != null).filter(watcher -> ((SmartReaction)watcher.getComponent()).getMessageId() == event.getMessageIdLong()).forEach(watcher -> watcher.onEvent((Event)event));
    }

    public static String getStatus() {
        StringBuilder builder = new StringBuilder();
        builder.append("WatcherManager: ").append(watchers.size()).append(" watchers").append("\n");
        watchers.forEach(watcher -> {
            Component patt0$temp = watcher.getComponent();
            if (patt0$temp instanceof CommandComponent) {
                CommandComponent cmd = (CommandComponent)patt0$temp;
                builder.append(cmd.isContextCommand() ? " - Context command: " : " - Slash command: ").append(watcher.getComponent().getName()).append("\n");
                return;
            }
            Component patt1$temp = watcher.getComponent();
            if (patt1$temp instanceof MessageComponent) {
                MessageComponent msg = (MessageComponent)patt1$temp;
                builder.append(" - Message listener").append("\n");
                if (msg.getFilterName() != null) {
                    builder.append("   - Filter: ").append(msg.getFilterName()).append("\n");
                }
                return;
            }
            builder.append(" - ").append(watcher.getComponent().getName()).append("\n");
            if (watcher.getComponent().getIdentifier() != null) {
                builder.append("   - IDENTIFIER: ").append(watcher.getComponent().getIdentifier()).append("\n");
            }
            builder.append("   - UUID: ").append(watcher.getComponent().getUuid()).append("\n");
        });
        return builder.toString();
    }
}

