/*
 * Decompiled with CFR 0.152.
 */
package org.mangorage.commonutils.jda.slash.component;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import net.dv8tion.jda.api.entities.Guild;
import net.dv8tion.jda.api.entities.Message;
import net.dv8tion.jda.api.events.interaction.command.SlashCommandInteractionEvent;
import net.dv8tion.jda.api.events.message.MessageReceivedEvent;
import net.dv8tion.jda.api.interactions.InteractionHook;
import net.dv8tion.jda.api.requests.restaction.MessageCreateAction;
import net.dv8tion.jda.api.requests.restaction.WebhookMessageEditAction;
import net.dv8tion.jda.api.requests.restaction.interactions.InteractionCallbackAction;
import net.dv8tion.jda.api.requests.restaction.interactions.ModalCallbackAction;
import net.dv8tion.jda.api.requests.restaction.interactions.ReplyCallbackAction;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.mangorage.commonutils.jda.slash.component.Component;
import org.mangorage.commonutils.jda.slash.component.NoRegistry;
import org.slf4j.LoggerFactory;

public abstract class SendableComponent
extends Component {
    private static final List<SendableComponent> instances = new ArrayList<SendableComponent>();
    protected Guild guild;
    protected long messageId = -1L;
    private boolean modal = false;

    @Nullable
    public static SendableComponent create(@NotNull Class<? extends SendableComponent> componentClass) {
        if (Arrays.asList(componentClass.getInterfaces()).contains(NoRegistry.class)) {
            throw new IllegalArgumentException("Component class is annotated with NoRegistry and cannot be created");
        }
        try {
            SendableComponent component = componentClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            instances.add(component);
            return component.create();
        }
        catch (Exception e) {
            LoggerFactory.getLogger(SendableComponent.class).error("Failed to create component", (Throwable)e);
            return null;
        }
    }

    @Nullable
    public static SendableComponent create(@NotNull Class<? extends SendableComponent> componentClass, Class<?>[] paramTypes, Object ... constructorArgs) {
        if (Arrays.asList(componentClass.getInterfaces()).contains(NoRegistry.class)) {
            throw new IllegalArgumentException("Component class is annotated with NoRegistry and cannot be created");
        }
        try {
            SendableComponent component = componentClass.getConstructor(paramTypes).newInstance(constructorArgs);
            instances.add(component);
            return component.create();
        }
        catch (Exception e) {
            LoggerFactory.getLogger(SendableComponent.class).error("Failed to create component", (Throwable)e);
            return null;
        }
    }

    public static List<SendableComponent> getInstances() {
        return instances;
    }

    protected SendableComponent(String name) {
        super(name);
    }

    protected abstract MessageCreateAction onSend(@NotNull MessageReceivedEvent var1);

    protected abstract InteractionCallbackAction onReply(@NotNull SlashCommandInteractionEvent var1);

    protected WebhookMessageEditAction<Message> onEdit(@NotNull InteractionHook hook) {
        return null;
    }

    protected void onSent(@NotNull Message message) {
    }

    protected abstract List<Component> getChildren();

    @Nullable
    public Component getChild(@NotNull String name) {
        for (Component component : this.getChildren()) {
            if (!component.getName().equals(name)) continue;
            return component;
        }
        return null;
    }

    @Nullable
    public Component getChild(@NotNull UUID uuid) {
        for (Component component : this.getChildren()) {
            if (!component.getUuid().equals(uuid)) continue;
            return component;
        }
        return null;
    }

    @Nullable
    public Component getChild(@NotNull String name, @NotNull Object identifier) {
        for (Component component : this.getChildren()) {
            if (!component.getName().equals(name) || component.getIdentifier() == null || !component.getIdentifier().equals(identifier)) continue;
            return component;
        }
        return null;
    }

    public List<Component> getChildrenFromType(@NotNull Class<? extends Component> clazz) {
        List<Component> components = this.getChildren();
        components.removeIf(component -> !component.getClass().equals(clazz));
        return components;
    }

    @Override
    @NotNull
    public final SendableComponent create() {
        super.create();
        return this;
    }

    @Override
    public final void remove() {
        if (!this.isCreated()) {
            return;
        }
        if (this.getChildren() != null) {
            this.getChildren().forEach(Component::remove);
        }
        super.remove();
        this.guild = null;
        this.messageId = -1L;
    }

    @Nullable
    public final Message send(@NotNull MessageReceivedEvent event) {
        if (!this.isCreated() || this.isSent()) {
            return null;
        }
        MessageCreateAction messageCreateAction = this.onSend(event);
        if (messageCreateAction == null) {
            return null;
        }
        Message hook = (Message)messageCreateAction.complete();
        this.guild = hook.getGuild();
        this.messageId = hook.getIdLong();
        this.onSent(hook);
        return hook;
    }

    @Nullable
    public final InteractionHook reply(@NotNull SlashCommandInteractionEvent event) {
        ReplyCallbackAction replyCallbackAction;
        if (!this.isCreated() || this.isSent()) {
            return null;
        }
        InteractionCallbackAction interactionCallbackAction = this.onReply(event);
        if (interactionCallbackAction == null) {
            return null;
        }
        if (interactionCallbackAction instanceof ModalCallbackAction) {
            ModalCallbackAction modalAction = (ModalCallbackAction)interactionCallbackAction;
            modalAction.queue();
            this.modal = true;
            return null;
        }
        try {
            replyCallbackAction = (ReplyCallbackAction)interactionCallbackAction;
        }
        catch (ClassCastException ignored) {
            throw new IllegalArgumentException("InteractionCallbackAction must be of type ReplyCallbackAction or ModalCallbackAction");
        }
        InteractionHook hook = (InteractionHook)replyCallbackAction.complete();
        Message message = (Message)hook.retrieveOriginal().complete();
        this.guild = message.getGuild();
        this.messageId = message.getIdLong();
        this.onSent(message);
        return hook;
    }

    public final void edit(@NotNull InteractionHook hook) {
        if (!this.isCreated() || this.isSent()) {
            return;
        }
        WebhookMessageEditAction<Message> editAction = this.onEdit(hook);
        if (editAction == null) {
            return;
        }
        Message message = (Message)editAction.complete();
        this.guild = message.getGuild();
        this.messageId = message.getIdLong();
        this.onSent(message);
        this.getChildren().stream().filter(SendableComponent.class::isInstance).forEach(component -> ((SendableComponent)component).onSent(message));
    }

    public final void restore(@NotNull Message message) {
        if (!this.isCreated()) {
            return;
        }
        this.guild = message.getGuild();
        this.messageId = message.getIdLong();
    }

    public final boolean isSent() {
        return this.messageId != -1L && this.guild != null || this.modal;
    }

    public final long getMessageId() {
        return this.messageId;
    }

    public Guild getGuild() {
        return this.guild;
    }
}

