/*
 * Decompiled with CFR 0.152.
 */
package org.mangorage.mangobotcore.jda.command.internal;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import net.dv8tion.jda.api.entities.Message;
import net.minecraftforge.eventbus.internal.Event;
import org.mangorage.commonutils.misc.Arguments;
import org.mangorage.commonutils.misc.TaskScheduler;
import org.mangorage.entrypoint.MangoBotCore;
import org.mangorage.mangobotcore.jda.command.api.CommandManager;
import org.mangorage.mangobotcore.jda.command.api.ICommand;
import org.mangorage.mangobotcore.jda.event.CommandEvent;

public final class CommandManagerImpl
implements CommandManager {
    private final Map<String, ICommand> commands = new HashMap<String, ICommand>();

    @Override
    public void register(ICommand command) {
        this.commands.putIfAbsent(command.id(), command);
    }

    @Override
    public void handle(Message message) {
        String rawMessage = message.getContentRaw();
        Object cmdPrefix = MangoBotCore.isDevMode() ? "dev!" : "!";
        boolean silent = false;
        if (rawMessage.startsWith("s" + (String)cmdPrefix)) {
            cmdPrefix = "s" + (String)cmdPrefix;
            silent = true;
        }
        if (rawMessage.startsWith((String)cmdPrefix)) {
            CommandEvent event;
            String[] command_pre = rawMessage.split(" ");
            Arguments arguments = Arguments.of(Arrays.copyOfRange(command_pre, 0, command_pre.length));
            String[] cmd = rawMessage.replaceFirst((String)cmdPrefix, "").split(" ");
            boolean success = false;
            for (ICommand command : this.commands.values()) {
                if (!command.commands().contains(cmd[0])) continue;
                command.execute(message, arguments).accept(message);
                success = true;
                break;
            }
            if (!success && (event = (CommandEvent)CommandEvent.BUS.fire((Event)new CommandEvent(message, cmd[0], arguments))).isHandled()) {
                event.getResult().accept(message);
            }
            if (silent) {
                TaskScheduler.getExecutor().schedule(() -> message.delete().queue(), 250L, TimeUnit.MILLISECONDS);
            }
        }
    }

    @Override
    public ICommand getCommand(String id) {
        return this.commands.get(id);
    }
}

