/*
 * Decompiled with CFR 0.152.
 */
package org.mangorage.mangobotcore.jda.command.internal;

import java.util.ArrayList;
import java.util.List;
import net.dv8tion.jda.api.entities.Message;
import net.minecraftforge.eventbus.internal.Event;
import org.mangorage.commonutils.misc.Arguments;
import org.mangorage.mangobotcore.jda.command.api.CommandManager;
import org.mangorage.mangobotcore.jda.command.api.ICommand;
import org.mangorage.mangobotcore.jda.event.CommandEvent;

public final class CommandManagerImpl
implements CommandManager {
    private final List<ICommand> commands = new ArrayList<ICommand>();

    @Override
    public void register(ICommand command) {
        this.commands.add(command);
    }

    @Override
    public void handle(Message message) {
        String cmdPrefix;
        String rawMessage = message.getContentRaw();
        if (rawMessage.startsWith(cmdPrefix = "?")) {
            String[] command_pre = rawMessage.split(" ");
            Arguments arguments = Arguments.of(Arguments.of(command_pre).getFrom(1).split(" "));
            String[] cmd = rawMessage.replaceFirst("\\" + cmdPrefix, "").split(" ");
            boolean success = false;
            for (ICommand command : this.commands) {
                if (!command.commands().contains(cmd[0])) continue;
                command.execute(message, arguments);
                success = true;
                break;
            }
            if (!success) {
                CommandEvent.BUS.post((Event)new CommandEvent(message, cmd[0], arguments));
            }
        }
    }
}

