/*
 * Decompiled with CFR 0.152.
 */
package org.mangorage.commonutils.config;

import org.mangorage.commonutils.config.Config;
import org.mangorage.commonutils.config.ISetting;
import org.mangorage.commonutils.config.ITransformer;
import org.mangorage.commonutils.config.Transformer;
import org.mangorage.commonutils.config.Transformers;

public class ConfigSetting<T>
implements ISetting<T> {
    private final Config config;
    private final String id;
    private final T defaultvalue;
    private final ITransformer<T, String> transformer;
    private final ITransformer<String, T> transformerReversed;

    public static ConfigSetting<String> create(Config config, String ID, String defaultValue) {
        return ConfigSetting.create(config, ID, Transformers.STRING, defaultValue);
    }

    public static <T> ConfigSetting<T> create(Config config, String ID, Transformer<T, String> transformer, T defaultValue) {
        return new ConfigSetting<T>(config, ID, transformer, defaultValue);
    }

    private ConfigSetting(Config config, String ID, Transformer<T, String> transformer, T defaultvalue) {
        this.config = config;
        this.id = ID;
        this.transformer = transformer.getTransformer();
        this.transformerReversed = transformer.getTransformerReversed();
        this.defaultvalue = defaultvalue;
        if (config.get(this.id) == null) {
            this.set(defaultvalue);
        }
    }

    @Override
    public T get() {
        T result = this.transformer.transform(this.config.get(this.id));
        return result != null ? result : this.defaultvalue;
    }

    @Override
    public void set(T value) {
        this.config.set(this.id, this.transformerReversed.transform(value));
        this.config.save();
    }
}

