/*
 * Decompiled with CFR 0.152.
 */
package org.mangorage.commonutils.misc;

import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.Objects;

public class PagedList<T> {
    private Page<T>[] pages;
    private int page_id = 0;
    private int entries = 0;

    public int totalPages() {
        return this.pages.length;
    }

    public Page<T> next() {
        this.page_id = this.page_id + 1 >= this.pages.length ? 0 : ++this.page_id;
        return this.pages[this.page_id];
    }

    public Page<T> current() {
        return this.pages[this.page_id];
    }

    public Page<T> previous() {
        this.page_id = this.page_id <= 0 ? this.pages.length - 1 : --this.page_id;
        return this.pages[this.page_id];
    }

    public int getPage() {
        return this.page_id + 1;
    }

    public void rebuild(T[] data, int entries) {
        if (data.length <= 0) {
            return;
        }
        this.entries = entries;
        Class<?> type = data[0].getClass();
        int index = 0;
        int page_index = 0;
        int remaining = data.length;
        int totalPages = (int)Math.abs(Math.ceil((double)data.length / (double)entries));
        this.pages = (Page[])Array.newInstance(Page.class, totalPages);
        while (remaining > 0) {
            Object[] entries_array = (Object[])Array.newInstance(type, entries);
            int remaining_entrys = entries;
            int entry_index = 0;
            while (remaining_entrys > 0 && index < data.length) {
                entries_array[entry_index] = data[index];
                ++entry_index;
                ++index;
                --remaining_entrys;
                --remaining;
            }
            this.pages[page_index] = new Page<Object>(type, entries_array);
            ++page_index;
        }
    }

    public int getEntriesPerPage() {
        return this.entries;
    }

    public static final class Page<T> {
        private final T[] entries;

        public Page(Class<T> type, T[] entries) {
            this.entries = (Object[])Array.newInstance(type, (int)Arrays.stream(entries).filter(Objects::nonNull).count());
            int index = 0;
            for (T entry : entries) {
                if (entry == null) continue;
                this.entries[index] = entry;
                ++index;
            }
        }

        public T[] getEntries() {
            return this.entries;
        }
    }
}

