/*
 * Decompiled with CFR 0.152.
 */
package org.mangorage.commonutils.misc;

import java.util.function.Function;

public final class Arguments {
    private static final Arguments EMPTY = new Arguments(new String[0]);
    private final String[] args;

    public static Arguments empty() {
        return EMPTY;
    }

    public static Arguments of(String ... args) {
        return new Arguments(args);
    }

    private Arguments(String[] args) {
        this.args = args;
    }

    public String[] getArgs() {
        return this.args;
    }

    public String get(int index) {
        return index >= this.args.length ? null : this.args[index];
    }

    public String getOrDefault(int index, String value) {
        return index >= this.args.length ? value : this.args[index];
    }

    public boolean has(int index) {
        return index < this.args.length;
    }

    public String getFrom(int index) {
        StringBuilder result = new StringBuilder();
        boolean first = false;
        while (this.has(index)) {
            result.append(" ").append(this.get(index));
            ++index;
        }
        return result.toString().trim();
    }

    public String findArg(String arg) {
        String result = null;
        int index = 0;
        while (this.has(index)) {
            if (this.get(index).equals(arg)) {
                result = this.get(index + 1);
                break;
            }
            ++index;
        }
        return result;
    }

    public String findArgOrDefault(String arg, String defaultValue) {
        String result = this.findArg(arg);
        return result == null ? defaultValue : result;
    }

    public <X> X findArg(String arg, Function<String, X> resolver) {
        String result = this.findArg(arg);
        X resolved_result = null;
        if (result != null) {
            try {
                resolved_result = resolver.apply(result);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return result == null || resolved_result == null ? null : resolved_result;
    }

    public <X> X findArgOrDefault(String arg, Function<String, X> resolver, X defaultValue) {
        String result = this.findArg(arg);
        Object resolved_result = null;
        if (result != null) {
            try {
                resolved_result = resolver.apply(result);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return (X)(result == null || resolved_result == null ? defaultValue : resolved_result);
    }

    public boolean hasArg(String arg) {
        int index = 0;
        while (this.has(index)) {
            if (this.get(index).equals(arg)) {
                return true;
            }
            ++index;
        }
        return false;
    }

    public int getArgIndex(String arg) {
        int index = 0;
        while (this.has(index)) {
            if (this.get(index).equals(arg)) {
                return index;
            }
            ++index;
        }
        return -1;
    }
}

