/*
 * Decompiled with CFR 0.152.
 */
package org.mangorage.commonutils.config;

import java.io.BufferedWriter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.attribute.FileAttribute;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Pattern;
import org.mangorage.commonutils.misc.FileMonitor;

public class Config {
    public static final Pattern CONFIG_REGEX = Pattern.compile("^\\s*([\\w.\\-]+)\\s*(=)\\s*(['][^']*[']|[\"][^\"]*[\"]|[^#]*)?\\s*(#.*)?$");
    private final Path file;
    private final ConcurrentHashMap<String, String> ENTRIES = new ConcurrentHashMap();

    public Config(Path file) {
        this(file, false);
    }

    public Config(Path file, boolean autoReload) {
        this.file = file;
        try {
            this.load();
            if (autoReload) {
                FileMonitor.getMonitor().register(file, kind -> {
                    if (kind == StandardWatchEventKinds.ENTRY_MODIFY) {
                        this.reload();
                    }
                }, StandardWatchEventKinds.ENTRY_MODIFY);
            }
        }
        catch (IOException e) {
            throw new IllegalStateException("Unable to load Config...");
        }
    }

    private void load() throws IOException {
        if (Files.exists(this.file, new LinkOption[0])) {
            Files.readAllLines(this.file).forEach(e -> {
                if (CONFIG_REGEX.matcher((CharSequence)e).matches()) {
                    String[] a = e.split("=", 2);
                    this.ENTRIES.put(a[0], a[1]);
                }
            });
        } else {
            Files.createDirectories(this.file.getParent(), new FileAttribute[0]);
            Files.createFile(this.file, new FileAttribute[0]);
        }
    }

    public void reload() {
        this.ENTRIES.clear();
        try {
            this.load();
        }
        catch (IOException e) {
            throw new IllegalStateException("Unable to reload config...");
        }
    }

    public String get(String ID) {
        return this.ENTRIES.get(ID);
    }

    public void set(String ID, String value) {
        this.ENTRIES.put(ID, value);
    }

    public Path getFile() {
        return this.file;
    }

    public void save() {
        try {
            BufferedWriter writer = Files.newBufferedWriter(this.file, new OpenOption[0]);
            this.ENTRIES.forEach((key, value) -> {
                String line = "%s=%s".formatted(key, value);
                try {
                    writer.write(line);
                    writer.newLine();
                }
                catch (IOException ex) {
                    throw new RuntimeException(ex);
                }
            });
            writer.flush();
            writer.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

