/*
 * Decompiled with CFR 0.152.
 */
package org.mangorage.commonutils.jda.slash.component;

import java.util.UUID;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.mangorage.commonutils.jda.slash.command.Unique;

public abstract class Component {
    protected UUID uuid;
    protected final String name;
    @Nullable
    private Object identifier;

    protected Component(String name) {
        this.name = name;
    }

    protected abstract void onCreate();

    protected abstract void onRemove();

    @NotNull
    public Component create() {
        if (this.isCreated()) {
            return this;
        }
        this.uuid = UUID.randomUUID();
        this.onCreate();
        return this;
    }

    public void remove() {
        if (!this.isCreated()) {
            return;
        }
        this.onRemove();
        this.uuid = null;
    }

    public final boolean isCreated() {
        return this.uuid != null;
    }

    public void setIdentifier(@Nullable Object identifier) {
        Unique.checkUnique("component", identifier, "Component identifier must be unique");
        this.identifier = identifier;
    }

    @Nullable
    public Object getIdentifier() {
        return this.identifier;
    }

    public final UUID getUuid() {
        return this.uuid;
    }

    public final String getName() {
        return this.name;
    }
}

