/*
 * Decompiled with CFR 0.152.
 */
package org.mangorage.commonutils.jda.slash.command;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import net.dv8tion.jda.api.events.interaction.command.CommandAutoCompleteInteractionEvent;
import net.dv8tion.jda.api.events.interaction.command.MessageContextInteractionEvent;
import net.dv8tion.jda.api.events.interaction.command.SlashCommandInteractionEvent;
import net.dv8tion.jda.api.events.interaction.command.UserContextInteractionEvent;
import net.dv8tion.jda.api.interactions.commands.Command;
import net.dv8tion.jda.api.interactions.commands.DefaultMemberPermissions;
import net.dv8tion.jda.api.interactions.commands.build.CommandData;
import net.dv8tion.jda.api.interactions.commands.build.Commands;
import net.dv8tion.jda.api.interactions.commands.build.OptionData;
import net.dv8tion.jda.api.interactions.commands.build.SlashCommandData;
import net.dv8tion.jda.api.interactions.commands.build.SubcommandData;
import net.dv8tion.jda.api.utils.data.DataObject;
import net.dv8tion.jda.internal.utils.Checks;
import org.jetbrains.annotations.NotNull;
import org.mangorage.commonutils.jda.slash.command.CommandComponent;
import org.mangorage.commonutils.jda.slash.command.CommandOption;
import org.mangorage.commonutils.jda.slash.command.OptionComponent;
import org.mangorage.commonutils.jda.slash.command.Unique;
import org.mangorage.commonutils.jda.slash.command.watcher.EventWatcher;

public final class Command {
    public static final List<CommandData> globalCommands = new ArrayList<CommandData>();

    public static SlashCommandBuilder slash(@NotNull String name, @NotNull String description) {
        Checks.notEmpty((CharSequence)name, (String)"Name");
        Checks.notEmpty((CharSequence)description, (String)"Description");
        Unique.checkUnique("slashcommand", name, "A slash command with the name '" + name + "' already exists");
        return new SlashCommandBuilder(name, description);
    }

    public static MessageContextBuilder message(@NotNull String name) {
        Checks.notEmpty((CharSequence)name, (String)"Name");
        Unique.checkUnique("message context", name, "A message context command with the name '" + name + "' already exists");
        return new MessageContextBuilder(name);
    }

    public static UserContextBuilder user(@NotNull String name) {
        Checks.notEmpty((CharSequence)name, (String)"Name");
        Unique.checkUnique("message context", name, "A user context command with the name '" + name + "' already exists");
        return new UserContextBuilder(name);
    }

    public static class SlashCommandBuilder
    implements Buildable<SlashCommandBuilder, SlashCommandData> {
        private final SlashCommandData data;
        private final List<String> aliases = new ArrayList<String>();
        private final Map<String, EventWatcher.Listener<CommandAutoCompleteInteractionEvent>> autocompleteListeners = new HashMap<String, EventWatcher.Listener<CommandAutoCompleteInteractionEvent>>();
        private final List<Function<SlashCommandInteractionEvent, Boolean>> conditions = new ArrayList<Function<SlashCommandInteractionEvent, Boolean>>();
        private EventWatcher.Listener<SlashCommandInteractionEvent> listener;
        private final Map<String, EventWatcher.Listener<CommandAutoCompleteInteractionEvent>> subCommandAutoCompleteListeners = new HashMap<String, EventWatcher.Listener<CommandAutoCompleteInteractionEvent>>();
        private final Map<String, List<Function<SlashCommandInteractionEvent, Boolean>>> subCommandConditions = new HashMap<String, List<Function<SlashCommandInteractionEvent, Boolean>>>();
        private final Map<String, EventWatcher.Listener<SlashCommandInteractionEvent>> subCommandListeners = new HashMap<String, EventWatcher.Listener<SlashCommandInteractionEvent>>();
        private boolean containsSubCommands;

        private SlashCommandBuilder(String name, String description) {
            this.data = Commands.slash((String)name, (String)description);
        }

        public SlashCommandBuilder addOption(@NotNull CommandOption option) {
            if (this.containsSubCommands) {
                throw new IllegalStateException("Cannot add an option to a slash command that contains sub commands");
            }
            OptionData optionData = new OptionData(option.type(), option.name(), option.description(), option.required(), option.autocomplete());
            for (Command.Choice choice : option.choices()) {
                optionData.addChoice(choice.getName(), choice.getAsString());
            }
            this.getData().addOptions(new OptionData[]{optionData});
            if (option.autocomplete() && option.autoCompleteListener() != null) {
                this.autocompleteListeners.put(option.name(), option.autoCompleteListener());
            }
            return this;
        }

        public SlashCommandBuilder addOptions(CommandOption ... options) {
            if (this.containsSubCommands) {
                throw new IllegalStateException("Cannot add an option to a slash command that contains sub commands");
            }
            for (CommandOption option : options) {
                this.addOption(option);
            }
            return this;
        }

        public SlashCommandBuilder executes(EventWatcher.Listener<SlashCommandInteractionEvent> listener) {
            if (this.containsSubCommands) {
                throw new IllegalStateException("Cannot add a listener to a slash command that contains sub commands");
            }
            this.listener = listener;
            return this;
        }

        public SlashCommandBuilder addCondition(Function<SlashCommandInteractionEvent, Boolean> condition) {
            if (this.containsSubCommands) {
                throw new IllegalStateException("Cannot add a condition to a slash command that contains sub commands");
            }
            this.conditions.add(condition);
            return this;
        }

        public SlashCommandBuilder addAlias(@NotNull String alias) {
            if (alias.equals(this.getData().getName())) {
                throw new IllegalArgumentException("Alias cannot be the same as the command name");
            }
            if (this.aliases.contains(alias)) {
                throw new IllegalArgumentException("Alias '" + alias + "' already exists");
            }
            Unique.checkUnique("slashcommand", alias, "A slash command or alias with the name '" + alias + "' already exists");
            this.aliases.add(alias);
            return this;
        }

        public SlashCommandBuilder addAliases(String ... aliases) {
            Arrays.stream(aliases).forEach(this::addAlias);
            return this;
        }

        public SubCommandBuilder addSubCommand(String name, String description) {
            if (this.listener != null) {
                throw new IllegalStateException("Cannot add a sub command to a slash command that contains a listener");
            }
            this.containsSubCommands = true;
            return new SubCommandBuilder(this, name, description);
        }

        @Override
        public SlashCommandData getData() {
            return this.data;
        }

        @Override
        public SlashCommandData build() {
            if (!this.containsSubCommands && this.listener != null) {
                new EventWatcher<SlashCommandInteractionEvent>(new CommandComponent(this.getData().getName(), this.aliases), SlashCommandInteractionEvent.class).setListener(this.listener).addConditions(this.conditions);
                for (Map.Entry<String, EventWatcher.Listener<CommandAutoCompleteInteractionEvent>> entry : this.autocompleteListeners.entrySet()) {
                    new EventWatcher<CommandAutoCompleteInteractionEvent>(new OptionComponent(this.getData().getName() + " " + entry.getKey()), CommandAutoCompleteInteractionEvent.class).setListener(entry.getValue());
                }
            } else {
                for (Map.Entry<String, EventWatcher.Listener<SlashCommandInteractionEvent>> entry : this.subCommandListeners.entrySet()) {
                    new EventWatcher<SlashCommandInteractionEvent>(new CommandComponent(this.getData().getName(), this.aliases, " " + entry.getKey()), SlashCommandInteractionEvent.class).setListener(entry.getValue()).addConditions(this.subCommandConditions.getOrDefault(entry.getKey(), Collections.emptyList()));
                }
                for (Map.Entry<String, EventWatcher.Listener<SlashCommandInteractionEvent>> entry : this.subCommandAutoCompleteListeners.entrySet()) {
                    new EventWatcher<CommandAutoCompleteInteractionEvent>(new OptionComponent(this.getData().getName() + " " + entry.getKey()), CommandAutoCompleteInteractionEvent.class).setListener(entry.getValue());
                }
            }
            return this.getData();
        }

        @Override
        public void buildAndRegister() {
            Buildable.super.buildAndRegister();
            this.aliases.forEach(alias -> globalCommands.add((CommandData)SlashCommandData.fromData((DataObject)this.getData().toData()).setName(alias)));
        }

        public static class SubCommandBuilder {
            private final SlashCommandBuilder parent;
            private final SubcommandData data;
            private final Map<String, EventWatcher.Listener<CommandAutoCompleteInteractionEvent>> autocompleteListeners = new HashMap<String, EventWatcher.Listener<CommandAutoCompleteInteractionEvent>>();
            private final List<Function<SlashCommandInteractionEvent, Boolean>> conditions = new ArrayList<Function<SlashCommandInteractionEvent, Boolean>>();
            private EventWatcher.Listener<SlashCommandInteractionEvent> listener;

            private SubCommandBuilder(SlashCommandBuilder parent, String name, String description) {
                this.parent = parent;
                this.data = new SubcommandData(name, description);
            }

            public SubCommandBuilder addOption(@NotNull CommandOption option) {
                this.data.addOption(option.type(), option.name(), option.description(), option.required(), option.autocomplete());
                if (option.autocomplete() && option.autoCompleteListener() != null) {
                    this.autocompleteListeners.put(option.name(), option.autoCompleteListener());
                }
                return this;
            }

            public SubCommandBuilder addOptions(CommandOption ... options) {
                for (CommandOption option : options) {
                    this.addOption(option);
                }
                return this;
            }

            public SubCommandBuilder executes(EventWatcher.Listener<SlashCommandInteractionEvent> listener) {
                if (this.listener != null) {
                    throw new IllegalStateException("Cannot add a listener to a sub command that already has a listener");
                }
                this.listener = listener;
                return this;
            }

            public SubCommandBuilder addCondition(Function<SlashCommandInteractionEvent, Boolean> condition) {
                this.conditions.add(condition);
                return this;
            }

            public SubCommandBuilder modifyData(@NotNull Function<SubcommandData, SubcommandData> function) {
                function.apply(this.data);
                return this;
            }

            public SlashCommandBuilder build() {
                this.parent.getData().addSubcommands(new SubcommandData[]{this.data});
                if (this.listener != null) {
                    this.parent.subCommandListeners.put(this.data.getName(), this.listener);
                    if (!this.conditions.isEmpty()) {
                        this.parent.subCommandConditions.put(this.data.getName(), this.conditions);
                    }
                    for (Map.Entry<String, EventWatcher.Listener<CommandAutoCompleteInteractionEvent>> entry : this.autocompleteListeners.entrySet()) {
                        this.parent.subCommandAutoCompleteListeners.put(this.data.getName() + " " + entry.getKey(), entry.getValue());
                    }
                }
                return this.parent;
            }
        }
    }

    public static class MessageContextBuilder
    implements Buildable<MessageContextBuilder, CommandData> {
        private final CommandData data;
        private final List<Function<MessageContextInteractionEvent, Boolean>> conditions = new ArrayList<Function<MessageContextInteractionEvent, Boolean>>();
        private EventWatcher.Listener<MessageContextInteractionEvent> listener;

        private MessageContextBuilder(String name) {
            this.data = Commands.message((String)name);
        }

        public MessageContextBuilder executes(EventWatcher.Listener<MessageContextInteractionEvent> listener) {
            this.listener = listener;
            return this;
        }

        public MessageContextBuilder addCondition(Function<MessageContextInteractionEvent, Boolean> condition) {
            this.conditions.add(condition);
            return this;
        }

        @Override
        public CommandData getData() {
            return this.data;
        }

        @Override
        public CommandData build() {
            if (this.listener != null) {
                new EventWatcher<MessageContextInteractionEvent>(new CommandComponent(this.getData().getName()).setContextCommand(true), MessageContextInteractionEvent.class).setListener(this.listener).addConditions(this.conditions);
            }
            return this.getData();
        }
    }

    public static class UserContextBuilder
    implements Buildable<UserContextBuilder, CommandData> {
        private final CommandData data;
        private final List<Function<UserContextInteractionEvent, Boolean>> conditions = new ArrayList<Function<UserContextInteractionEvent, Boolean>>();
        private EventWatcher.Listener<UserContextInteractionEvent> listener;

        private UserContextBuilder(String name) {
            this.data = Commands.user((String)name);
        }

        public UserContextBuilder executes(EventWatcher.Listener<UserContextInteractionEvent> listener) {
            this.listener = listener;
            return this;
        }

        public UserContextBuilder addCondition(Function<UserContextInteractionEvent, Boolean> condition) {
            this.conditions.add(condition);
            return this;
        }

        @Override
        public CommandData getData() {
            return this.data;
        }

        @Override
        public CommandData build() {
            if (this.listener != null) {
                new EventWatcher<UserContextInteractionEvent>(new CommandComponent(this.getData().getName()).setContextCommand(true), UserContextInteractionEvent.class).setListener(this.listener).addConditions(this.conditions);
            }
            return this.getData();
        }
    }

    static interface GlobalModifiers<R, T extends CommandData> {
        public T getData();

        default public R modifyData(@NotNull Function<T, T> function) {
            function.apply(this.getData());
            return (R)this;
        }

        default public R setDefaultPermissions(DefaultMemberPermissions defaultPermissions) {
            this.getData().setDefaultPermissions(defaultPermissions);
            return (R)this;
        }

        default public R setNSFW(boolean nsfw) {
            this.getData().setNSFW(nsfw);
            return (R)this;
        }

        default public R setGuildOnly() {
            this.getData().setGuildOnly(true);
            return (R)this;
        }
    }

    static interface Buildable<R, T extends CommandData>
    extends GlobalModifiers<R, T> {
        public T build();

        default public void buildAndRegister() {
            T data = this.build();
            globalCommands.add((CommandData)data);
        }
    }
}

