/*
 * Decompiled with CFR 0.152.
 */
package org.mangorage.commonutils.data;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.mangorage.commonutils.data.FileName;
import org.mangorage.commonutils.data.IFileNameResolver;
import org.mangorage.commonutils.misc.APIUtil;

public class DataHandler<T extends IFileNameResolver> {
    private static final Gson DEFAULT_GSON = new GsonBuilder().setPrettyPrinting().create();
    private final Class<T> tClass;
    private final Gson gson;
    private final String path;
    private final boolean isFile;
    private final int maxDepth;

    public static Builder create() {
        return new Builder();
    }

    private static void save(String content, Path path) throws IOException {
        if (!Files.exists(path.getParent(), new LinkOption[0])) {
            Files.createDirectories(path.getParent(), new FileAttribute[0]);
        }
        Files.writeString(path, (CharSequence)content, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);
    }

    private DataHandler(Class<T> tClass, Gson gson, String path, boolean isFile, int maxDepth) {
        this.tClass = tClass;
        this.gson = gson;
        this.path = !isFile ? path : (path.endsWith(".json") ? path : path + ".json");
        this.isFile = isFile;
        this.maxDepth = maxDepth;
    }

    public void save(Path rootDirectory, T ... objects) {
        if (objects.length == 0) {
            return;
        }
        Path resolved = rootDirectory.resolve(this.path).toAbsolutePath();
        if (this.isFile) {
            String data = this.gson.toJson(objects[0]);
            try {
                DataHandler.save(data, resolved);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        } else {
            for (T object : objects) {
                String data = this.gson.toJson(object);
                try {
                    FileName fn = object.resolve();
                    DataHandler.save(data, resolved.resolve(fn.path()).resolve(fn.name() + ".json").toAbsolutePath());
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        }
    }

    public void delete(Path rootDirectory, T ... objects) {
        if (objects.length == 0) {
            return;
        }
        Path resolved = rootDirectory.resolve(this.path).toAbsolutePath();
        if (this.isFile) {
            try {
                Files.deleteIfExists(resolved);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        } else {
            for (T object : objects) {
                FileName fn = object.resolve();
                Path filePath = resolved.resolve(fn.path()).resolve(fn.name() + ".json").toAbsolutePath();
                try {
                    Files.deleteIfExists(filePath);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        }
    }

    public List<T> load(Path rootDirectory) {
        ArrayList list = new ArrayList();
        Path resolved = rootDirectory.resolve(this.path).toAbsolutePath();
        if (Files.exists(resolved, new LinkOption[0]) && !this.isFile) {
            APIUtil.scanDirectory(resolved.toFile(), this.maxDepth).stream().map(Path::toFile).filter(file -> file.isFile() && !file.isDirectory()).forEach(f -> {
                try {
                    IFileNameResolver obj = (IFileNameResolver)this.gson.fromJson((Reader)new FileReader((File)f), this.tClass);
                    list.add(obj);
                }
                catch (FileNotFoundException e) {
                    throw new RuntimeException(e);
                }
            });
        }
        return list;
    }

    public Optional<T> loadFile(Path rootDirectory) {
        Path resolved;
        if (this.isFile && Files.exists(resolved = rootDirectory.resolve(this.path).toAbsolutePath(), new LinkOption[0])) {
            try {
                IFileNameResolver obj = (IFileNameResolver)this.gson.fromJson((Reader)new FileReader(resolved.toFile()), this.tClass);
                return Optional.of(obj);
            }
            catch (FileNotFoundException e) {
                throw new RuntimeException(e);
            }
        }
        return Optional.empty();
    }

    public static class Builder {
        private boolean isFile = false;
        private String path = "";
        private int maxDepth = 0;
        private Gson gson = DEFAULT_GSON;

        public Builder file() {
            this.isFile = true;
            return this;
        }

        public Builder setGson(Gson gson) {
            this.gson = gson;
            return this;
        }

        public Builder path(String path) {
            this.path = path;
            return this;
        }

        public Builder maxDepth(int depth) {
            this.maxDepth = depth;
            return this;
        }

        public <T extends IFileNameResolver> DataHandler<T> build(Class<T> tClass) {
            return new DataHandler<T>(tClass, this.gson, this.path, this.isFile, this.maxDepth);
        }
    }
}

