/*
 * Decompiled with CFR 0.152.
 */
package org.mangorage.mangobotcore.plugin.internal;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URLClassLoader;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.mangorage.commonutils.log.LogHelper;
import org.mangorage.mangobotcore.plugin.api.MangoBotPlugin;
import org.mangorage.mangobotcore.plugin.api.Plugin;
import org.mangorage.mangobotcore.plugin.api.PluginContainer;
import org.mangorage.mangobotcore.plugin.api.PluginManager;
import org.mangorage.mangobotcore.plugin.internal.MetadataImpl;
import org.mangorage.mangobotcore.plugin.internal.PluginContainerImpl;
import org.mangorage.mangobotcore.plugin.internal.dependency.DependencyImpl;
import org.mangorage.mangobotcore.plugin.internal.dependency.Library;
import org.mangorage.mangobotcore.plugin.internal.dependency.LibraryManager;
import org.mangorage.scanner.api.Scanner;
import org.mangorage.scanner.api.ScannerBuilder;

public final class PluginManagerImpl
implements PluginManager {
    private static final Gson GSON = new GsonBuilder().create();
    public static final PluginManagerImpl INSTANCE = new PluginManagerImpl();
    private final Map<String, PluginContainer> plugins = new HashMap<String, PluginContainer>();

    private static InputStream getFileFromClassLoader(String filePath) {
        InputStream inputStream = PluginManager.class.getClassLoader().getResourceAsStream(filePath);
        if (inputStream == null) {
            System.out.println("File not found: " + filePath);
        }
        return inputStream;
    }

    PluginManagerImpl() {
    }

    public void load() {
        LogHelper.info("Gathering Plugin Info...");
        LibraryManager manager = new LibraryManager();
        Scanner scanner = ScannerBuilder.of().addClassloader((URLClassLoader)Thread.currentThread().getContextClassLoader()).build();
        scanner.commitScan();
        scanner.findClassesWithAnnotation(MangoBotPlugin.class).forEach(clz -> {
            MangoBotPlugin annotation = clz.getAnnotation(MangoBotPlugin.class);
            if (Plugin.class.isAssignableFrom((Class<?>)clz)) {
                LogHelper.info("Found Plugin with ID '%s', now attempting to find metadata".formatted(annotation.id()));
                InputStream metadataIS = PluginManagerImpl.getFileFromClassLoader(annotation.id() + ".plugin.json");
                if (metadataIS == null) {
                    throw new IllegalStateException("Unable to find plugin.json for '%s'".formatted(annotation.id()));
                }
                MetadataImpl metadata = (MetadataImpl)GSON.fromJson((Reader)new InputStreamReader(metadataIS), MetadataImpl.class);
                LogHelper.info("Found Metadata for plugin '%s'".formatted(annotation.id()));
                manager.addLibrary(annotation.id(), new PluginContainerImpl((Class<?>)clz, metadata));
            }
        });
        LogHelper.info("Organizing Plugin Load Order...");
        for (Library library : List.copyOf(manager.getLibraries())) {
            List<DependencyImpl> dependencies = ((PluginContainerImpl)library.getObject()).getMetadata().dependencies();
            if (dependencies != null && !dependencies.isEmpty()) {
                LogHelper.info("Found %s dependencies for '%s'".formatted(dependencies.size(), ((PluginContainerImpl)library.getObject()).getMetadata().getId()));
                manager.addDependenciesForLibrary(((PluginContainerImpl)library.getObject()).getMetadata().getId(), dependencies);
                continue;
            }
            LogHelper.info("Found no dependencies for '%s'".formatted(((PluginContainerImpl)library.getObject()).getMetadata().getId()));
        }
        LogHelper.info("Loading Plugins...");
        for (Library library : manager.getLibrariesInOrder()) {
            this.loadPlugin((PluginContainerImpl)library.getObject());
        }
        LogHelper.info("Calling init Method on all Plugins...");
        this.plugins.forEach((k, v) -> {
            Object patt0$temp = v.getInstance();
            if (patt0$temp instanceof Plugin) {
                Plugin plugin = (Plugin)patt0$temp;
                plugin.load();
            }
        });
        LogHelper.info("Finished loading plugins...");
    }

    @Override
    public PluginContainer getPlugin(String id) {
        return this.plugins.get(id);
    }

    public void loadPlugin(PluginContainerImpl container) {
        String pluginId = container.getMetadata().getId();
        LogHelper.info("Loading plugin: %s".formatted(pluginId));
        this.plugins.put(container.getMetadata().getId(), container);
        try {
            container.init();
        }
        catch (Exception e) {
            LogHelper.error("Failed to load plugin: " + pluginId);
            LogHelper.error(e.getMessage());
            e.printStackTrace();
        }
    }
}

