/*
 * Decompiled with CFR 0.152.
 */
package org.mangorage.mangobot.loader;

import java.io.File;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;

public final class Loader {
    public static void main(String[] args) {
        URLClassLoader CL_libraries = new URLClassLoader(Loader.fetchJars(new File[]{new File("libraries")}), Thread.currentThread().getContextClassLoader().getParent());
        URLClassLoader cl = new URLClassLoader(Loader.fetchJars(new File[]{new File("plugins")}), (ClassLoader)CL_libraries);
        Thread.currentThread().setContextClassLoader(cl);
        Loader.callMain("org.mangorage.entrypoint.MangoBotCore", args, cl);
    }

    public static URL[] fetchJars(File[] directories) {
        ArrayList<URL> urls = new ArrayList<URL>();
        for (File dir : directories) {
            File[] jarFiles;
            if (!dir.exists() || !dir.isDirectory() || (jarFiles = dir.listFiles((d, name) -> name.endsWith(".jar"))) == null) continue;
            for (File jar : jarFiles) {
                try {
                    urls.add(jar.toURI().toURL());
                }
                catch (MalformedURLException e) {
                    throw new RuntimeException("Malformed URL while processing: " + jar.getAbsolutePath(), e);
                }
            }
        }
        return (URL[])urls.toArray(URL[]::new);
    }

    public static void callMain(String className, String[] args, ClassLoader classLoader) {
        try {
            Class<?> clazz = Class.forName(className, false, classLoader);
            Method mainMethod = clazz.getMethod("main", String[].class);
            if (!Modifier.isStatic(mainMethod.getModifiers())) {
                throw new IllegalStateException("Main method is not static, are you high?");
            }
            mainMethod.invoke(null, new Object[]{args});
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException("Couldn't reflectively call main because something exploded.", e);
        }
    }
}

