/*
 * Decompiled with CFR 0.152.
 */
package org.mangorage.commonutils.misc;

import com.google.gson.Gson;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import net.dv8tion.jda.api.entities.GuildVoiceState;
import net.dv8tion.jda.api.entities.Member;
import net.dv8tion.jda.api.entities.channel.unions.AudioChannelUnion;
import net.dv8tion.jda.api.managers.channel.middleman.AudioChannelManager;

public class APIUtil {
    public static boolean isValidBotToken(String token) {
        return true;
    }

    public static List<Path> scanDirectory(File directory, int maxDepth) {
        return APIUtil.scanDirectory(directory, 0, maxDepth);
    }

    private static List<Path> scanDirectory(File directory, int currentDepth, int maxDepth) {
        ArrayList<Path> paths = new ArrayList<Path>();
        if (currentDepth > maxDepth) {
            return paths;
        }
        File[] files = directory.listFiles();
        if (files != null) {
            for (File file : files) {
                paths.add(file.toPath());
                if (!file.isDirectory()) continue;
                paths.addAll(APIUtil.scanDirectory(file, currentDepth + 1, maxDepth));
            }
        }
        return paths;
    }

    public static List<File> getFilesInDir(String dir) {
        File file = new File(dir);
        if (file.isDirectory() && file.listFiles() != null) {
            return Arrays.asList(file.listFiles());
        }
        return List.of();
    }

    public static void saveObjectToFile(Gson gson, Object object, String directory, String fileName) {
        try {
            String jsonData = gson.toJson(object);
            File dirs = new File(directory);
            if (!dirs.exists() && !dirs.mkdirs()) {
                return;
            }
            Files.writeString(Path.of("%s/%s".formatted(directory, fileName), new String[0]), (CharSequence)jsonData, new OpenOption[0]);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static void deleteFile(String directory, String fileName) {
        try {
            Files.delete(Path.of("%s/%s".formatted(directory, fileName), new String[0]));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static <T> T loadJsonToObject(Gson gson, String file, Class<T> cls) {
        try {
            return (T)gson.fromJson(Files.readString(Path.of(file, new String[0])), cls);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static boolean inVC(Member member) {
        return member.getVoiceState() != null && member.getVoiceState().inAudioChannel();
    }

    public static AudioChannelUnion getVoiceChannel(Member member) {
        if (member == null) {
            return null;
        }
        GuildVoiceState state = member.getVoiceState();
        if (state == null) {
            return null;
        }
        if (!state.inAudioChannel()) {
            return null;
        }
        return state.getChannel();
    }

    public static Optional<AudioChannelUnion> getLazyVoiceChannel(Member member) {
        return Optional.ofNullable(APIUtil.getVoiceChannel(member));
    }

    public static AudioChannelManager<?, ?> getAudioChannelManager(Member member) {
        AudioChannelUnion vc = APIUtil.getVoiceChannel(member);
        if (vc == null) {
            return null;
        }
        return vc.getManager();
    }

    public static Optional<AudioChannelManager<?, ?>> getLazyAudioChannelManager(Member member) {
        return Optional.ofNullable(APIUtil.getAudioChannelManager(member));
    }
}

