/*
 * Decompiled with CFR 0.152.
 */
package org.mangorage.commonutils.jda.slash.component.interact;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import net.dv8tion.jda.api.entities.Message;
import net.dv8tion.jda.api.entities.MessageEmbed;
import net.dv8tion.jda.api.entities.User;
import net.dv8tion.jda.api.entities.emoji.Emoji;
import net.dv8tion.jda.api.entities.emoji.EmojiUnion;
import net.dv8tion.jda.api.events.interaction.command.SlashCommandInteractionEvent;
import net.dv8tion.jda.api.events.message.MessageReceivedEvent;
import net.dv8tion.jda.api.events.message.react.MessageReactionAddEvent;
import net.dv8tion.jda.api.events.message.react.MessageReactionRemoveEvent;
import net.dv8tion.jda.api.requests.restaction.MessageCreateAction;
import net.dv8tion.jda.api.requests.restaction.interactions.ReplyCallbackAction;
import org.jetbrains.annotations.NotNull;
import org.mangorage.commonutils.jda.slash.command.watcher.EventWatcher;
import org.mangorage.commonutils.jda.slash.component.Component;
import org.mangorage.commonutils.jda.slash.component.NoRegistry;
import org.mangorage.commonutils.jda.slash.component.SendableComponent;

public class SmartReaction
extends SendableComponent
implements NoRegistry {
    private final List<Emoji> reactions = new ArrayList<Emoji>();
    private EventWatcher<MessageReactionAddEvent> onAdd;
    private EventWatcher<MessageReactionRemoveEvent> onRemove;
    private String message;
    private MessageEmbed embed;

    private SmartReaction() {
        super("SmartReaction");
    }

    @NotNull
    public static SmartReaction create(String message) {
        SmartReaction reaction = new SmartReaction();
        reaction.message = message;
        reaction.create();
        return reaction;
    }

    @NotNull
    public static SmartReaction create(MessageEmbed embed) {
        SmartReaction reaction = new SmartReaction();
        reaction.embed = embed;
        reaction.create();
        return reaction;
    }

    public SmartReaction addReaction(Emoji emoji) {
        this.reactions.add(emoji);
        return this;
    }

    public SmartReaction addReaction(String emoji) {
        this.reactions.add((Emoji)Emoji.fromFormatted((String)emoji));
        return this;
    }

    public SmartReaction withListeners(EventWatcher.Listener<MessageReactionAddEvent> onAdd, EventWatcher.Listener<MessageReactionRemoveEvent> onRemove) {
        this.onAdd.setListener(event -> {
            EmojiUnion emoji = event.getEmoji();
            if (this.getReactions().contains(emoji)) {
                onAdd.onEvent((MessageReactionAddEvent)event);
            } else {
                event.getReaction().removeReaction((User)event.retrieveUser().complete()).queue();
            }
        });
        this.onRemove.setListener(event -> {
            EmojiUnion emoji = event.getEmoji();
            if (this.getReactions().contains(emoji)) {
                onRemove.onEvent((MessageReactionRemoveEvent)event);
            }
        });
        return this;
    }

    public SmartReaction withListeners(EventWatcher.Listener<MessageReactionAddEvent> onAdd, EventWatcher.Listener<MessageReactionRemoveEvent> onRemove, int expireAfter, TimeUnit unit) {
        this.onAdd.setListener(event -> {
            EmojiUnion emoji = event.getEmoji();
            if (this.getReactions().contains(emoji)) {
                onAdd.onEvent((MessageReactionAddEvent)event);
            } else {
                event.getReaction().removeReaction((User)event.retrieveUser().complete()).queue();
            }
        }, expireAfter, unit);
        this.onRemove.setListener(event -> {
            EmojiUnion emoji = event.getEmoji();
            if (this.getReactions().contains(emoji)) {
                onRemove.onEvent((MessageReactionRemoveEvent)event);
            }
        }, expireAfter, unit);
        return this;
    }

    @Override
    protected void onCreate() {
        this.onAdd = new EventWatcher<MessageReactionAddEvent>(this, MessageReactionAddEvent.class);
        this.onRemove = new EventWatcher<MessageReactionRemoveEvent>(this, MessageReactionRemoveEvent.class);
    }

    @Override
    protected void onRemove() {
        this.onAdd.destroy();
        this.onRemove.destroy();
    }

    @Override
    protected MessageCreateAction onSend(@NotNull MessageReceivedEvent event) {
        if (this.getReactions().isEmpty()) {
            throw new IllegalStateException("No reactions added to the SmartReaction");
        }
        if (this.message != null) {
            return event.getChannel().sendMessage((CharSequence)this.message);
        }
        return event.getChannel().sendMessageEmbeds(this.embed, new MessageEmbed[0]);
    }

    protected ReplyCallbackAction onReply(@NotNull SlashCommandInteractionEvent event) {
        if (this.getReactions().isEmpty()) {
            throw new IllegalStateException("No reactions added to the SmartReaction");
        }
        if (this.message != null) {
            return event.reply(this.message);
        }
        return event.replyEmbeds(this.embed, new MessageEmbed[0]);
    }

    @Override
    protected void onSent(@NotNull Message message) {
        for (Emoji emoji : this.reactions) {
            message.addReaction(emoji).queue();
        }
    }

    @Override
    protected List<Component> getChildren() {
        return null;
    }

    public List<Emoji> getReactions() {
        return this.reactions;
    }
}

