/*
 * Decompiled with CFR 0.152.
 */
package org.mangorage.commonutils.jda;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.dv8tion.jda.api.events.interaction.component.ButtonInteractionEvent;
import org.mangorage.commonutils.jda.ButtonAction;

public class ButtonActionRegistry {
    private final Set<ButtonAction> ACTIONS = new HashSet<ButtonAction>();
    private final Map<Class<?>, ButtonAction> ACTIONS_BY_MAP = new HashMap();
    private final Set<String> ACTIONS_REGISTERED = new HashSet<String>();

    public void register(ButtonAction buttonAction) {
        if (this.ACTIONS.contains(buttonAction) || this.ACTIONS_BY_MAP.containsKey(buttonAction.getClass())) {
            throw new IllegalStateException("Cannot register Button Action %s due to already being registered".formatted(buttonAction.getId()));
        }
        if (this.ACTIONS_REGISTERED.contains(buttonAction.getId())) {
            throw new IllegalStateException("Cannot register Button Action %s due to a Button Action with Similar Id being present".formatted(buttonAction.getId()));
        }
        this.ACTIONS.add(buttonAction);
        this.ACTIONS_BY_MAP.put(buttonAction.getClass(), buttonAction);
        this.ACTIONS_REGISTERED.add(buttonAction.getId());
    }

    public void post(ButtonInteractionEvent event) {
        for (ButtonAction action : this.ACTIONS) {
            if (action.onClick(event)) break;
        }
    }

    public <T extends ButtonAction> T get(Class<T> tClass) {
        ButtonAction result = this.ACTIONS_BY_MAP.get(tClass);
        return (T)(result == null ? null : result);
    }
}

