/*
 * Decompiled with CFR 0.152.
 */
package org.mangorage.mangobot.loader;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.Path;
import java.util.ArrayList;

public final class Loader {
    public static void main(String[] args) {
        boolean isDev = false;
        for (String arg : args) {
            if (!arg.contains("--dev")) continue;
            isDev = true;
        }
        System.out.println("Path: " + String.valueOf(Path.of("", new String[0]).toAbsolutePath()));
        URLClassLoader CL_libraries = new URLClassLoader(Loader.fetchJars(new File[]{new File("libraries")}), isDev ? null : Thread.currentThread().getContextClassLoader());
        try (URLClassLoader loader = new URLClassLoader(Loader.fetchJars(new File[]{new File("plugins")}), (ClassLoader)CL_libraries);){
            Thread.currentThread().setContextClassLoader(loader);
            Class<?> clazz = Class.forName("org.mangorage.entrypoint.MangoBotCore", false, loader);
            System.out.println(clazz.getClassLoader());
            Method method = clazz.getDeclaredMethod("main", String[].class);
            method.invoke(null, new Object[]{args});
        }
        catch (IOException | ReflectiveOperationException e) {
            throw new RuntimeException("Failed to launch the application", e);
        }
    }

    public static URL[] fetchJars(File[] directories) {
        ArrayList<URL> urls = new ArrayList<URL>();
        for (File dir : directories) {
            File[] jarFiles;
            if (!dir.exists() || !dir.isDirectory() || (jarFiles = dir.listFiles((d, name) -> name.endsWith(".jar"))) == null) continue;
            for (File jar : jarFiles) {
                try {
                    urls.add(jar.toURI().toURL());
                }
                catch (MalformedURLException e) {
                    throw new RuntimeException("Malformed URL while processing: " + jar.getAbsolutePath(), e);
                }
            }
        }
        System.out.println("Found: " + urls.size());
        return (URL[])urls.toArray(URL[]::new);
    }
}

