/*
 * Decompiled with CFR 0.152.
 */
package org.mangorage.commonutils.jda.slash.message;

import org.jetbrains.annotations.NotNull;
import org.mangorage.commonutils.jda.slash.command.Unique;
import org.mangorage.commonutils.jda.slash.command.watcher.EventWatcher;
import org.mangorage.commonutils.jda.slash.command.watcher.MessageFilterEvent;
import org.mangorage.commonutils.jda.slash.message.MessageComponent;

public abstract class Filter {
    private final String name;
    private final String description;
    private final EventWatcher<MessageFilterEvent> watcher;

    protected Filter(String name, String description) {
        Unique.checkUnique("filter-name", name, "Filter name is not unique");
        this.name = name;
        this.description = description;
        this.watcher = new EventWatcher<MessageFilterEvent>(new MessageComponent(this), MessageFilterEvent.class);
    }

    public final Filter withListener(@NotNull EventWatcher.Listener<MessageFilterEvent> listener) {
        this.watcher.setListener(listener);
        return this;
    }

    protected abstract boolean onMessageReceived(@NotNull MessageFilterEvent var1);

    protected final void destroy() {
        this.watcher.destroy();
    }

    public final String getName() {
        return this.name;
    }

    public final String getDescription() {
        return this.description;
    }
}

