/*
 * Decompiled with CFR 0.152.
 */
package org.mangorage.commonutils.jda.slash.component.interact;

import java.util.concurrent.TimeUnit;
import net.dv8tion.jda.api.entities.emoji.Emoji;
import net.dv8tion.jda.api.events.interaction.component.ButtonInteractionEvent;
import net.dv8tion.jda.api.interactions.components.buttons.Button;
import net.dv8tion.jda.api.interactions.components.buttons.ButtonStyle;
import org.jetbrains.annotations.NotNull;
import org.mangorage.commonutils.jda.slash.command.watcher.EventWatcher;
import org.mangorage.commonutils.jda.slash.component.Component;
import org.mangorage.commonutils.jda.slash.component.NoRegistry;

public class SmartButton
extends Component
implements NoRegistry {
    private Button parent;
    private final EventWatcher<ButtonInteractionEvent> eventWatcher;
    private final String label;
    private final Emoji emoji;
    private final ButtonStyle style;
    private final String url;

    private SmartButton(String label, Emoji emoji, ButtonStyle style, String url) {
        super("SmartButton");
        this.label = label;
        this.emoji = emoji;
        this.style = style;
        this.url = url;
        this.eventWatcher = new EventWatcher<ButtonInteractionEvent>(this, ButtonInteractionEvent.class);
    }

    public static SmartButton primary(@NotNull String label) {
        return new ButtonBuilder(label, ButtonStyle.PRIMARY).build();
    }

    public static SmartButton primary(@NotNull Emoji emoji) {
        return new ButtonBuilder(emoji, ButtonStyle.PRIMARY).build();
    }

    public static SmartButton secondary(@NotNull String label) {
        return new ButtonBuilder(label, ButtonStyle.SECONDARY).build();
    }

    public static SmartButton secondary(@NotNull Emoji emoji) {
        return new ButtonBuilder(emoji, ButtonStyle.SECONDARY).build();
    }

    public static SmartButton success(@NotNull String label) {
        return new ButtonBuilder(label, ButtonStyle.SUCCESS).build();
    }

    public static SmartButton success(@NotNull Emoji emoji) {
        return new ButtonBuilder(emoji, ButtonStyle.SUCCESS).build();
    }

    public static SmartButton danger(@NotNull String label) {
        return new ButtonBuilder(label, ButtonStyle.DANGER).build();
    }

    public static SmartButton danger(@NotNull Emoji emoji) {
        return new ButtonBuilder(emoji, ButtonStyle.DANGER).build();
    }

    public static SmartButton link(@NotNull String url, @NotNull String label) {
        return new ButtonBuilder(label, ButtonStyle.LINK).setUrl(url).build();
    }

    public static SmartButton link(@NotNull String url, @NotNull Emoji emoji) {
        return new ButtonBuilder(emoji, ButtonStyle.LINK).setUrl(url).build();
    }

    public SmartButton withListener(EventWatcher.Listener<ButtonInteractionEvent> listener) {
        this.eventWatcher.setListener(listener);
        return this;
    }

    public SmartButton withListener(EventWatcher.Listener<ButtonInteractionEvent> listener, int expireAfter, TimeUnit unit) {
        this.eventWatcher.setListener(listener, expireAfter, unit);
        return this;
    }

    public Button build() {
        return this.parent;
    }

    @Override
    protected void onCreate() {
        this.parent = Button.of((ButtonStyle)this.style, (String)(this.style == ButtonStyle.LINK ? this.url : this.uuid.toString()), (String)this.label, (Emoji)this.emoji);
    }

    @Override
    protected void onRemove() {
        this.eventWatcher.destroy();
        this.parent = null;
    }

    static class ButtonBuilder {
        private final String label;
        private final Emoji emoji;
        private final ButtonStyle style;
        private String url;

        private ButtonBuilder(String label, ButtonStyle style) {
            this.label = label;
            this.emoji = null;
            this.style = style;
        }

        private ButtonBuilder(Emoji emoji, ButtonStyle style) {
            this.label = null;
            this.emoji = emoji;
            this.style = style;
        }

        public ButtonBuilder setUrl(String url) {
            this.url = url;
            return this;
        }

        public SmartButton build() {
            SmartButton button = new SmartButton(this.label, this.emoji, this.style, this.url);
            button.create();
            return button;
        }
    }
}

