/*
 * Decompiled with CFR 0.152.
 */
package org.mangorage.commonutils.jda.slash.command;

import java.util.ArrayList;
import java.util.List;
import net.dv8tion.jda.api.events.interaction.command.CommandAutoCompleteInteractionEvent;
import net.dv8tion.jda.api.interactions.commands.Command;
import net.dv8tion.jda.api.interactions.commands.OptionType;
import org.jetbrains.annotations.Nullable;
import org.mangorage.commonutils.jda.slash.command.watcher.EventWatcher;

public class CommandOption {
    private final OptionType type;
    private final String name;
    private final String description;
    private final boolean required;
    private final boolean autocomplete;
    private final List<Command.Choice> choices = new ArrayList<Command.Choice>();
    private EventWatcher.Listener<CommandAutoCompleteInteractionEvent> autoCompleteListener;

    public CommandOption(OptionType type, String name, String description, boolean required, boolean autocomplete) {
        this.type = type;
        this.name = name;
        this.description = description;
        this.required = required;
        this.autocomplete = autocomplete;
        if (autocomplete && !type.canSupportChoices()) {
            throw new IllegalStateException("This option type does not support auto completions");
        }
    }

    public CommandOption(OptionType type, String name, String description, boolean required) {
        this(type, name, description, required, false);
    }

    public CommandOption(OptionType type, String name, String description) {
        this(type, name, description, false);
    }

    public CommandOption addChoice(Command.Choice choice) {
        this.choices.add(choice);
        return this;
    }

    public CommandOption addChoice(String name, String value) {
        this.choices.add(new Command.Choice(name, value));
        return this;
    }

    public CommandOption addChoices(Command.Choice ... choices) {
        for (Command.Choice choice : choices) {
            this.addChoice(choice);
        }
        return this;
    }

    public CommandOption onAutoComplete(EventWatcher.Listener<CommandAutoCompleteInteractionEvent> listener) {
        if (!this.autocomplete) {
            throw new IllegalStateException("Cannot add an autocomplete listener to a non-autocomplete option");
        }
        this.autoCompleteListener = listener;
        return this;
    }

    public OptionType type() {
        return this.type;
    }

    public String name() {
        return this.name;
    }

    public String description() {
        return this.description;
    }

    public boolean required() {
        return this.required;
    }

    public boolean autocomplete() {
        return this.autocomplete;
    }

    public List<Command.Choice> choices() {
        return this.choices;
    }

    @Nullable
    public EventWatcher.Listener<CommandAutoCompleteInteractionEvent> autoCompleteListener() {
        return this.autoCompleteListener;
    }
}

