/*
 * Decompiled with CFR 0.152.
 */
package org.mangorage.commonutils.jda.slash.message;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.dv8tion.jda.api.entities.Guild;
import net.dv8tion.jda.api.events.message.MessageReceivedEvent;
import net.dv8tion.jda.internal.utils.Checks;
import org.jetbrains.annotations.NotNull;
import org.mangorage.commonutils.jda.slash.command.watcher.MessageFilterEvent;
import org.mangorage.commonutils.jda.slash.message.Filter;

public class MessageFilter {
    private static final Map<Long, MessageFilter> filters = new ConcurrentHashMap<Long, MessageFilter>();
    private final Guild guild;
    private final List<Filter> messageFilters = new ArrayList<Filter>();

    public static MessageFilter get(@NotNull Guild guild) {
        Checks.notNull((Object)guild, (String)"Guild");
        return filters.computeIfAbsent(guild.getIdLong(), guildID -> new MessageFilter(guild));
    }

    public static void destroyAll() {
        filters.values().forEach(MessageFilter::destroy);
        filters.clear();
    }

    @NotNull
    public static List<Filter> broadcastEvent(@NotNull MessageReceivedEvent event) {
        Checks.notNull((Object)event, (String)"Event");
        ArrayList<Filter> triggeredFilters = new ArrayList<Filter>();
        filters.values().stream().filter(filter -> filter.guild.getIdLong() == event.getGuild().getIdLong()).forEach(filter -> triggeredFilters.addAll(filter.onMessageReceived(event)));
        return triggeredFilters;
    }

    private MessageFilter(@NotNull Guild guild) {
        this.guild = guild;
    }

    @NotNull
    private List<Filter> onMessageReceived(@NotNull MessageReceivedEvent event) {
        ArrayList<Filter> triggeredFilters = new ArrayList<Filter>();
        this.messageFilters.forEach(filter -> {
            if (filter.onMessageReceived(MessageFilterEvent.of(filter, event)) && !triggeredFilters.contains(filter)) {
                triggeredFilters.add((Filter)filter);
            }
        });
        return triggeredFilters;
    }

    public void destroy() {
        this.messageFilters.forEach(Filter::destroy);
        this.messageFilters.clear();
        filters.remove(this.guild.getIdLong());
    }

    public void addFilter(@NotNull Filter filter) {
        Checks.notNull((Object)filter, (String)"Filter");
        if (!this.messageFilters.contains(filter)) {
            this.messageFilters.add(filter);
        }
    }

    public void removeFilter(@NotNull String filterName) {
        Checks.notNull((Object)filterName, (String)"Filter name");
        this.messageFilters.removeIf(filter -> filter.getName().equalsIgnoreCase(filterName));
    }

    public List<Filter> getMessageFilters() {
        return this.messageFilters;
    }

    public Guild getGuild() {
        return this.guild;
    }
}

