/*
 * Decompiled with CFR 0.152.
 */
package org.mangorage.commonutils.jda.slash.command.watcher;

import net.dv8tion.jda.api.entities.MessageType;
import net.dv8tion.jda.api.events.message.MessageReceivedEvent;
import net.dv8tion.jda.internal.utils.Checks;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.mangorage.commonutils.jda.slash.message.Filter;

public class MessageFilterEvent
extends MessageReceivedEvent {
    private final Filter filter;

    private MessageFilterEvent(@NotNull Filter filter, @NotNull MessageReceivedEvent event) {
        super(event.getJDA(), event.getResponseNumber(), event.getMessage());
        this.filter = filter;
    }

    @Contract(value="_, _ -> new")
    @NotNull
    public static MessageFilterEvent of(@NotNull Filter filter, @NotNull MessageReceivedEvent event) {
        Checks.notNull((Object)filter, (String)"Filter");
        Checks.notNull((Object)event, (String)"Event");
        return new MessageFilterEvent(filter, event);
    }

    @NotNull
    public String getMessageRaw() {
        return this.getMessage().getContentRaw();
    }

    public boolean isFromAutoMod() {
        return this.isFromType(MessageType.AUTO_MODERATION_ACTION);
    }

    public Filter getFilter() {
        return this.filter;
    }

    public boolean isFromType(@NotNull MessageType type) {
        return this.getMessage().getType() == type;
    }
}

