/*
 * Decompiled with CFR 0.152.
 */
package org.mangorage.commonutils.misc;

import java.io.IOException;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.util.HashMap;
import java.util.function.Consumer;

public class FileMonitor
extends Thread {
    private static final FileMonitor MONITOR = new FileMonitor();
    private final WatchService service;
    private final HashMap<Path, Consumer<WatchEvent.Kind<?>>> REGISTERED = new HashMap();

    public static FileMonitor getMonitor() {
        return MONITOR;
    }

    private FileMonitor() {
        try {
            this.service = FileSystems.getDefault().newWatchService();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void register(Path path, Consumer<WatchEvent.Kind<?>> consumer, WatchEvent.Kind<?> ... kinds) {
        Path parentDirectory = path.toAbsolutePath().getParent();
        if (parentDirectory != null && Files.isDirectory(parentDirectory, new LinkOption[0])) {
            try {
                this.REGISTERED.put(path.toAbsolutePath(), consumer);
                parentDirectory.register(this.service, kinds);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        } else {
            System.err.println("Cannot register file for monitoring without a valid parent directory: " + String.valueOf(path));
        }
    }

    @Override
    public void run() {
        try {
            while (true) {
                WatchKey key = this.service.take();
                block3: for (WatchEvent<?> event : key.pollEvents()) {
                    WatchEvent.Kind<?> kind = event.kind();
                    if (kind == StandardWatchEventKinds.OVERFLOW) continue;
                    Path relativePath = (Path)event.context();
                    Path modifiedPath = (Path)key.watchable();
                    modifiedPath = modifiedPath.resolve(relativePath);
                    for (Path registeredPath : this.REGISTERED.keySet()) {
                        if (!registeredPath.equals(modifiedPath.toAbsolutePath())) continue;
                        this.REGISTERED.get(registeredPath).accept(kind);
                        continue block3;
                    }
                }
                key.reset();
            }
        }
        catch (InterruptedException interruptedException) {
            return;
        }
    }

    public void close() {
        try {
            this.service.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    static {
        MONITOR.start();
    }
}

