/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.launcher.shadow.joptsimple.util;

import java.util.Locale;
import java.util.regex.Pattern;
import net.minecraftforge.launcher.shadow.joptsimple.ValueConversionException;
import net.minecraftforge.launcher.shadow.joptsimple.ValueConverter;
import net.minecraftforge.launcher.shadow.joptsimple.internal.Messages;

public class RegexMatcher
implements ValueConverter<String> {
    private final Pattern pattern;

    public RegexMatcher(String pattern, int flags) {
        this.pattern = Pattern.compile(pattern, flags);
    }

    public static ValueConverter<String> regex(String pattern) {
        return new RegexMatcher(pattern, 0);
    }

    @Override
    public String convert(String value) {
        if (!this.pattern.matcher(value).matches()) {
            this.raiseValueConversionFailure(value);
        }
        return value;
    }

    @Override
    public Class<String> valueType() {
        return String.class;
    }

    @Override
    public String valuePattern() {
        return this.pattern.pattern();
    }

    private void raiseValueConversionFailure(String value) {
        String message = Messages.message(Locale.getDefault(), "net.minecraftforge.launcher.shadow.joptsimple.ExceptionMessages", RegexMatcher.class, "message", value, this.pattern.pattern());
        throw new ValueConversionException(message);
    }
}

