/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.launcher;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import net.minecraftforge.launcher.Constants;
import net.minecraftforge.launcher.DownloadAssets;
import net.minecraftforge.launcher.shadow.joptsimple.AbstractOptionSpec;
import net.minecraftforge.launcher.shadow.joptsimple.ArgumentAcceptingOptionSpec;
import net.minecraftforge.launcher.shadow.joptsimple.OptionParser;
import net.minecraftforge.launcher.shadow.joptsimple.OptionSet;
import net.minecraftforge.launcher.shadow.net.minecraftforge.util.data.json.JsonData;
import net.minecraftforge.launcher.shadow.net.minecraftforge.util.data.json.MinecraftVersion;
import net.minecraftforge.launcher.shadow.net.minecraftforge.util.logging.Log;

public final class Main {
    public static void main(String[] args) throws Throwable {
        Launcher launcher;
        long start = System.currentTimeMillis();
        try {
            Log.capture();
            launcher = Main.run(args);
        }
        catch (Throwable e) {
            Log.release();
            throw e;
        }
        long total = System.currentTimeMillis() - start;
        if (Log.isCapturing()) {
            Log.drop();
            Log.INFO.print("Slime Launcher setup is up-to-date");
        } else {
            Log.INFO.print("Slime Launcher has finished setting up");
        }
        Log.INFO.println(", took " + total + "ms\n");
        launcher.run();
    }

    private static Launcher run(String[] args) throws Throwable {
        MethodHandle mainMethod;
        MinecraftVersion versionJson;
        OptionParser parser = new OptionParser();
        parser.allowsUnrecognizedOptions();
        AbstractOptionSpec helpO = parser.accepts("help", "Displays this help message and exits").forHelp();
        ArgumentAcceptingOptionSpec<File> cache0 = parser.accepts("cache", "Directory to store launcher metadata").withRequiredArg().ofType(File.class);
        ArgumentAcceptingOptionSpec<File> assetsO = parser.accepts("assets", "Directory to store assets").withRequiredArg().ofType(File.class).defaultsTo(Constants.ASSETS_DIR, (File[])new File[0]);
        ArgumentAcceptingOptionSpec<String> assetsRepo0 = parser.accepts("assets-repo", "The assets repository (download server)").withRequiredArg().ofType(String.class).defaultsTo("https://resources.download.minecraft.net/", (String[])new String[0]);
        ArgumentAcceptingOptionSpec<File> metadataZip0 = parser.accepts("metadata", "The metadata.zip to use for runs").withRequiredArg().ofType(File.class);
        ArgumentAcceptingOptionSpec<String> mainClassO = parser.accepts("main", "The main class to run").withRequiredArg().ofType(String.class);
        Package pkg = Main.class.getPackage();
        Log.info(pkg.getImplementationTitle() + " " + pkg.getImplementationVersion());
        SplitArgs split = new SplitArgs(args);
        OptionSet options = parser.parse(split.sl);
        if (options.has(helpO)) {
            parser.printHelpOn(Log.INFO);
            Log.info("To pass arguments into the main class,\nadd '--' after the Slime Launcher arguments,\nfollowed by your main arguments.");
            throw new IllegalArgumentException("Incomplete or invalid arguments");
        }
        File cache = options.valueOf(cache0);
        File assets = options.valueOf(assetsO);
        String assetsRepo = options.valueOf(assetsRepo0);
        File metadataZip = options.valueOf(metadataZip0);
        String mainClass = options.valueOf(mainClassO);
        try (ZipFile zip = new ZipFile(metadataZip);){
            versionJson = JsonData.minecraftVersion(Main.extract(zip, "minecraft/version.json", cache));
        }
        Log.info("Checking assets");
        byte indent = Log.push();
        DownloadAssets.download(assetsRepo, assets, versionJson);
        Log.pop(indent);
        Log.info("Looking for main class: " + mainClass);
        try {
            Class<?> main = Class.forName(mainClass);
            mainMethod = MethodHandles.publicLookup().findStatic(main, "main", MethodType.methodType(Void.TYPE, String[].class));
        }
        catch (ClassNotFoundException | IllegalAccessException | NoSuchMethodException e) {
            throw new IllegalStateException("Could not find main class!", e);
        }
        Log.info("Sanitizing Minecraft arguments");
        for (int i = 0; i < split.mc.length; ++i) {
            ((SplitArgs)split).mc[i] = split.mc[i].replace("{asset_index}", versionJson.assetIndex.id).replace("{assets_root}", assets.getAbsolutePath());
        }
        return new Launcher(mainClass, mainMethod, split.mc);
    }

    private static File extract(ZipFile zip, String name, File cache) throws IOException {
        File metadataDir = new File(cache, "metadata");
        if (!metadataDir.exists() && !metadataDir.mkdirs()) {
            throw new IllegalStateException("Failed to create directory: " + metadataDir.getAbsolutePath());
        }
        ZipEntry entry = zip.getEntry(name);
        if (entry == null) {
            throw new FileNotFoundException("Missing " + name + " in " + zip.getName());
        }
        File output = new File(metadataDir, name);
        File outputDir = output.getParentFile();
        if (!outputDir.exists() && !outputDir.mkdirs()) {
            throw new IllegalStateException("Failed to create directory: " + outputDir.getAbsolutePath());
        }
        try (FileOutputStream out = new FileOutputStream(output);){
            int length;
            InputStream stream = zip.getInputStream(entry);
            byte[] buf = new byte[8192];
            while ((length = stream.read(buf)) != -1) {
                out.write(buf, 0, length);
            }
        }
        return output;
    }

    private static final class SplitArgs {
        private final String[] sl;
        private final String[] mc;

        private SplitArgs(String[] args) {
            int splitIdx = -1;
            for (int i = 0; i < args.length; ++i) {
                if (!args[i].equals("--")) continue;
                splitIdx = i;
                break;
            }
            if (splitIdx < 0) {
                this.sl = args;
                this.mc = new String[0];
            } else {
                this.sl = new String[splitIdx];
                this.mc = new String[args.length - splitIdx - 1];
                System.arraycopy(args, 0, this.sl, 0, splitIdx);
                System.arraycopy(args, splitIdx + 1, this.mc, 0, args.length - splitIdx - 1);
            }
        }
    }

    private static final class Launcher {
        private final String name;
        private final MethodHandle main;
        private final String[] args;

        private Launcher(String name, MethodHandle main, String[] args) {
            this.name = name;
            this.main = main;
            this.args = args;
        }

        private void run() throws Throwable {
            Log.info("Launching using main class: " + this.name);
            this.main.invokeExact(this.args);
        }
    }
}

