/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.launcher;

import java.io.File;
import java.util.Map;
import net.minecraftforge.launcher.shadow.net.minecraftforge.util.data.json.AssetsIndex;
import net.minecraftforge.launcher.shadow.net.minecraftforge.util.data.json.JsonData;
import net.minecraftforge.launcher.shadow.net.minecraftforge.util.data.json.MinecraftVersion;
import net.minecraftforge.launcher.shadow.net.minecraftforge.util.download.DownloadUtils;
import net.minecraftforge.launcher.shadow.net.minecraftforge.util.hash.HashFunction;
import net.minecraftforge.launcher.shadow.net.minecraftforge.util.logging.Log;

final class DownloadAssets {
    DownloadAssets() {
    }

    static void download(String repo, File assetsDir, MinecraftVersion versionJson) {
        AssetsIndex index = JsonData.assetsIndex(DownloadAssets.downloadIndex(versionJson, assetsDir));
        File objectsDir = new File(assetsDir, "objects");
        if (!objectsDir.exists() && !objectsDir.mkdirs()) {
            throw new IllegalStateException("Failed to create objects directory: " + objectsDir);
        }
        for (Map.Entry<String, AssetsIndex.Asset> entry : index.objects.entrySet()) {
            String name = entry.getKey();
            AssetsIndex.Asset asset = entry.getValue();
            String assetDest = DownloadAssets.getAssetDest(asset.hash);
            File file = new File(objectsDir, assetDest);
            if (file.exists()) {
                Log.debug("Considering existing file with size " + file.length() + " and hash " + asset.hash + " for " + name);
                if (file.length() == asset.size && HashFunction.SHA1.sneakyHash(file).equals(asset.hash)) {
                    Log.debug("Hash and size check succeeded. Skipping.");
                    continue;
                }
            }
            Log.release();
            try {
                Log.info("Downloading missing asset: " + name);
                DownloadUtils.downloadFile(file, repo + assetDest);
            }
            catch (Exception e) {
                throw new IllegalStateException("Failed to download " + name, e);
            }
        }
    }

    private static String getAssetDest(String hash) {
        return hash.substring(0, 2) + "/" + hash;
    }

    private static File downloadIndex(MinecraftVersion versionJson, File assetsDir) {
        File index = new File(assetsDir, "indexes/" + versionJson.assetIndex.id + ".json");
        if (index.exists() && HashFunction.SHA1.sneakyHash(index).equals(versionJson.assetIndex.sha1)) {
            return index;
        }
        if (!index.getParentFile().getAbsoluteFile().exists() && !index.getParentFile().getAbsoluteFile().mkdirs()) {
            throw new IllegalArgumentException("Failed to create index directory: " + index.getParentFile());
        }
        try {
            DownloadUtils.downloadFile(index, versionJson.assetIndex.url);
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to download assets index", e);
        }
        String newSha1 = HashFunction.SHA1.sneakyHash(index);
        if (!newSha1.equals(versionJson.assetIndex.sha1)) {
            throw new IllegalStateException(String.format("Failed to verify assets index. Expected %s got %s", versionJson.assetIndex.sha1, newSha1));
        }
        return index;
    }
}

