/*
 * Decompiled with CFR 0.152.
 */
package cpw.mods.util;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.nio.channels.FileChannel;
import java.nio.channels.SeekableByteChannel;
import java.nio.file.FileSystem;
import java.nio.file.Path;
import net.minecraftforge.unsafe.UnsafeHacks;

public class ZipUtils {
    private static final MethodHandle ZIPFS_EXISTS;
    private static final MethodHandle ZIPFS_CH;
    private static final MethodHandle FCI_UNINTERUPTIBLE;

    public static SeekableByteChannel getByteChannel(FileSystem zfs) throws Throwable {
        return ZIPFS_CH.invoke(zfs);
    }

    public static void setUninterruptible(SeekableByteChannel byteChannel) throws Throwable {
        if (byteChannel instanceof FileChannel) {
            FCI_UNINTERUPTIBLE.invoke(byteChannel);
        }
    }

    public static boolean exists(Path path) throws Throwable {
        return ZIPFS_EXISTS.invoke(path);
    }

    static {
        try {
            Field hackfield = MethodHandles.Lookup.class.getDeclaredField("IMPL_LOOKUP");
            UnsafeHacks.setAccessible((AccessibleObject)hackfield);
            MethodHandles.Lookup hack = (MethodHandles.Lookup)hackfield.get(null);
            Class<?> clz = Class.forName("jdk.nio.zipfs.ZipPath");
            ZIPFS_EXISTS = hack.findSpecial(clz, "exists", MethodType.methodType(Boolean.TYPE), clz);
            clz = Class.forName("jdk.nio.zipfs.ZipFileSystem");
            ZIPFS_CH = hack.findGetter(clz, "ch", SeekableByteChannel.class);
            clz = Class.forName("sun.nio.ch.FileChannelImpl");
            FCI_UNINTERUPTIBLE = hack.findSpecial(clz, "setUninterruptible", MethodType.methodType(Void.TYPE), clz);
        }
        catch (ClassNotFoundException | IllegalAccessException | NoSuchFieldException | NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
    }
}

