/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.roimfs;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.FileSystem;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.ProviderMismatchException;
import java.nio.file.ReadOnlyFileSystemException;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.util.Arrays;
import java.util.Iterator;
import java.util.NoSuchElementException;
import net.minecraftforge.roimfs.RoimFileSystem;

class RoimPath
implements Path {
    final RoimFileSystem fs;
    private final char[] path;
    private int[] offsets = null;
    private int hashcode = 0;
    private Path normalized = null;
    private RoimPath resolved = null;

    RoimPath(RoimFileSystem fs, String path) {
        this(fs, RoimPath.normalize(path), false);
    }

    RoimPath(RoimFileSystem fs, char[] path, boolean navigationNormalized) {
        this.fs = fs;
        this.path = path;
        if (navigationNormalized) {
            this.normalized = this;
        }
    }

    static char[] normalize(String data) {
        if (data.length() == 0) {
            return new char[0];
        }
        char[] chrs = data.toCharArray();
        int len = chrs.length;
        int prev = 0;
        for (int x = 0; x < len; ++x) {
            int c = chrs[x];
            if (c == 92) {
                c = 47;
                chrs[x] = 47;
            }
            if (c == 47 && prev == 47) {
                int end = x;
                while (end++ < len && (chrs[end] == '/' || chrs[end] == '\\')) {
                }
                if (end < len) {
                    int t = x;
                    for (int y = end; y < len; ++y) {
                        chrs[t++] = chrs[y];
                    }
                    len -= end - x;
                    --x;
                } else {
                    len = x;
                }
            }
            prev = c;
        }
        if (len > 1 && chrs[len - 1] == '/') {
            --len;
        }
        if (chrs.length != len) {
            chrs = Arrays.copyOf(chrs, len);
        }
        return chrs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initOffsets() {
        if (this.offsets != null) {
            return;
        }
        int count = 0;
        if (this.path.length == 0) {
            count = 1;
        } else {
            int x = 0;
            while (x < this.path.length) {
                char c;
                if ((c = this.path[x++]) == '/') continue;
                ++count;
                while (x < this.path.length && this.path[x++] != '/') {
                }
            }
        }
        int[] result = new int[count];
        count = 0;
        for (int x = 0; x < this.path.length; ++x) {
            char c = this.path[x];
            if (c == '/') continue;
            result[count++] = x;
            while (++x < this.path.length && this.path[x] != '/') {
            }
        }
        RoimPath roimPath = this;
        synchronized (roimPath) {
            if (this.offsets == null) {
                this.offsets = result;
            }
        }
    }

    private static RoimPath cast(Path path) {
        if (path == null) {
            throw new NullPointerException();
        }
        if (!(path instanceof RoimPath)) {
            throw new ProviderMismatchException();
        }
        return (RoimPath)path;
    }

    @Override
    public int hashCode() {
        int ret = this.hashcode;
        if (ret == 0) {
            ret = this.hashcode = Arrays.hashCode(this.path);
        }
        return ret;
    }

    @Override
    public boolean equals(Object obj) {
        return obj instanceof RoimPath && this.fs == ((RoimPath)obj).fs && this.compareTo((Path)obj) == 0;
    }

    @Override
    public String toString() {
        return new String(this.path);
    }

    @Override
    public int compareTo(Path other) {
        RoimPath o = RoimPath.cast(other);
        int len = this.path.length;
        if (o.path.length < len) {
            len = o.path.length;
        }
        for (int x = 0; x < len; ++x) {
            if (this.path[x] == o.path[x]) continue;
            return this.path[x] - o.path[x];
        }
        return this.path.length - o.path.length;
    }

    @Override
    public FileSystem getFileSystem() {
        return this.fs;
    }

    @Override
    public boolean isAbsolute() {
        return this.path.length > 0 && this.path[0] == '/';
    }

    @Override
    public Path getRoot() {
        return this.isAbsolute() ? this.fs.rootPath : null;
    }

    @Override
    public Path getFileName() {
        int x = this.path.length;
        if (x == 0) {
            return this;
        }
        if (x == 1 && this.path[0] == '/') {
            return null;
        }
        while (--x >= 0 && this.path[x] != '/') {
        }
        if (x < 0) {
            return this;
        }
        return new RoimPath(this.fs, Arrays.copyOfRange(this.path, x + 1, this.path.length), true);
    }

    @Override
    public Path getParent() {
        int x = this.path.length;
        if (x == 0 || x == 1 && this.path[0] == '/') {
            return null;
        }
        while (--x >= 0 && this.path[x] != '/') {
        }
        if (x <= 0) {
            return this.getRoot();
        }
        return new RoimPath(this.fs, Arrays.copyOfRange(this.path, 0, x), false);
    }

    @Override
    public int getNameCount() {
        this.initOffsets();
        return this.offsets.length;
    }

    @Override
    public Path getName(int index) {
        this.initOffsets();
        if (index < 0 || index >= this.offsets.length) {
            throw new IllegalArgumentException();
        }
        int start = this.offsets[index];
        int end = index == this.offsets.length - 1 ? this.path.length : this.offsets[index + 1] - 1;
        return new RoimPath(this.fs, Arrays.copyOfRange(this.path, start, end), false);
    }

    @Override
    public Path subpath(int beginIndex, int endIndex) {
        this.initOffsets();
        if (beginIndex < 0 || beginIndex >= endIndex || beginIndex >= this.offsets.length || endIndex > this.offsets.length) {
            throw new IllegalArgumentException();
        }
        int start = this.offsets[beginIndex];
        int end = endIndex == this.offsets.length ? this.path.length : this.offsets[endIndex] - 1;
        return new RoimPath(this.fs, Arrays.copyOfRange(this.path, start, end), false);
    }

    @Override
    public boolean startsWith(String other) {
        return this.startsWith(this.fs.getPath(other, new String[0]));
    }

    @Override
    public boolean startsWith(Path other) {
        if (other == null) {
            throw new NullPointerException();
        }
        if (!(other instanceof RoimPath)) {
            return false;
        }
        RoimPath o = (RoimPath)other;
        if (o.fs != this.fs || o.isAbsolute() != this.isAbsolute() || o.path.length > this.path.length) {
            return false;
        }
        for (int x = 0; x < o.path.length; ++x) {
            if (o.path[x] == this.path[x]) continue;
            return false;
        }
        if (o.path.length == this.path.length) {
            return true;
        }
        if (o.path[o.path.length - 1] == '/') {
            return true;
        }
        return this.path[o.path.length] == '/';
    }

    @Override
    public boolean endsWith(String other) {
        return this.endsWith(this.fs.getPath(other, new String[0]));
    }

    @Override
    public boolean endsWith(Path other) {
        int tlen;
        if (other == null) {
            throw new NullPointerException();
        }
        if (!(other instanceof RoimPath)) {
            return false;
        }
        RoimPath o = (RoimPath)other;
        if (o.fs != this.fs) {
            return false;
        }
        int olen = o.path.length - 1;
        if (olen > 0 && o.path[olen] == '/') {
            --olen;
        }
        if ((tlen = this.path.length - 1) > 0 && this.path[tlen] == '/') {
            --tlen;
        }
        if (olen == -1) {
            return tlen == -1;
        }
        if (o.isAbsolute() && (!this.isAbsolute() || olen != tlen)) {
            return false;
        }
        if (olen > tlen) {
            return false;
        }
        while (olen >= 0) {
            if (o.path[olen--] == this.path[tlen--]) continue;
            return false;
        }
        if (o.isAbsolute()) {
            return true;
        }
        return tlen == -1 || this.path[tlen] == '/';
    }

    @Override
    public Path normalize() {
        if (this.normalized == null) {
            this.normalized = this.normalizeInternal();
        }
        return this.normalized;
    }

    private Path normalizeInternal() {
        char[] data = null;
        int lastSep = -1;
        int write = 0;
        int len = this.path.length;
        for (int x = 0; x < len; ++x) {
            char c = this.path[x];
            if (c == '/') {
                if (x <= 2) {
                    if (x == 1 && this.path[0] == '.') {
                        data = new char[len - 2];
                        continue;
                    }
                } else if (this.path[x - 1] == '.') {
                    if (lastSep == x - 2) {
                        if (data == null) {
                            data = new char[len - 2];
                            System.arraycopy(this.path, 0, data, 0, x - 1);
                            write = x - 1;
                            lastSep = x;
                            continue;
                        }
                        write -= 2;
                    } else if (this.path[x - 2] == '.' && lastSep == x - 3) {
                        if (data == null) {
                            write = x - 3;
                            while (write-- > 0 && this.path[write] != '/') {
                            }
                            if (write <= 0) {
                                data = new char[this.path.length - x];
                            } else {
                                data = new char[this.path.length - (x - write)];
                                System.arraycopy(this.path, 0, data, 0, write);
                            }
                        } else {
                            write -= 3;
                            while (write-- > 0 && data[write] != '/') {
                            }
                        }
                        if (write < 0) {
                            write = 0;
                            if (this.path[0] != '/') continue;
                        }
                    }
                }
                lastSep = x;
            }
            if (data == null) continue;
            data[write++] = c;
        }
        if (lastSep == len - 2 && this.path[len - 1] == '.') {
            if (data == null) {
                return new RoimPath(this.fs, Arrays.copyOf(this.path, lastSep), true);
            }
            write -= 2;
        } else if (lastSep == len - 3 && this.path[len - 1] == '.' && this.path[len - 2] == '.') {
            if (data == null) {
                return new RoimPath(this.fs, Arrays.copyOf(this.path, lastSep), true);
            }
            write -= 3;
            while (write-- > 0 && data[write] != '/') {
            }
        }
        if (data == null) {
            return this;
        }
        if (data.length == write) {
            return new RoimPath(this.fs, data, true);
        }
        return new RoimPath(this.fs, Arrays.copyOfRange(data, 0, write), true);
    }

    @Override
    public Path resolve(String other) {
        char[] opath = RoimPath.normalize(other);
        if (opath.length == 0) {
            return this;
        }
        if (opath[0] == '/' || this.path.length == 0) {
            return new RoimPath(this.fs, opath, false);
        }
        return this.resolve(opath);
    }

    @Override
    public Path resolve(Path other) {
        RoimPath o = RoimPath.cast(other);
        if (o.path.length == 0) {
            return this;
        }
        if (o.isAbsolute() || this.path.length == 0) {
            return o;
        }
        return this.resolve(o.path);
    }

    private Path resolve(char[] opath) {
        char[] joined;
        if (this.path[this.path.length - 1] == '/') {
            joined = Arrays.copyOf(this.path, this.path.length + opath.length);
            System.arraycopy(opath, 0, joined, this.path.length, opath.length);
        } else {
            joined = Arrays.copyOf(this.path, this.path.length + 1 + opath.length);
            joined[this.path.length] = 47;
            System.arraycopy(opath, 0, joined, this.path.length + 1, opath.length);
        }
        return new RoimPath(this.fs, joined, false);
    }

    @Override
    public Path relativize(Path other) {
        int start;
        int matched;
        RoimPath o = RoimPath.cast(other);
        if (this.equals(o)) {
            return new RoimPath(this.fs, new char[0], true);
        }
        if (this.path.length == 0) {
            return o;
        }
        if (this.fs != o.fs) {
            throw new IllegalArgumentException("Can't relativize across file systems");
        }
        if (this.isAbsolute() != o.isAbsolute()) {
            throw new IllegalArgumentException("Can't relativize between absolute and non-absolute paths");
        }
        if (this.path.length == 1 && this.path[0] == '/') {
            return new RoimPath(this.fs, Arrays.copyOfRange(o.path, 1, o.path.length), false);
        }
        this.initOffsets();
        o.initOffsets();
        int len = this.offsets.length;
        if (o.offsets.length < len) {
            len = o.offsets.length;
        }
        for (matched = 0; matched < len && (start = this.offsets[matched]) == o.offsets[matched]; ++matched) {
            int oend;
            int end = matched == this.offsets.length - 1 ? this.path.length : this.offsets[matched + 1] - 1;
            int n = oend = matched == o.offsets.length - 1 ? o.path.length : o.offsets[matched + 1] - 1;
            if (end != oend || !RoimPath.matches(this.path, o.path, start, end)) break;
        }
        int extra = this.getNameCount() - matched;
        int size = extra * 3 - 1;
        if (matched < o.getNameCount()) {
            size += o.path.length - o.offsets[matched] + 1;
        }
        char[] ret = new char[size];
        int write = 0;
        for (int x = 0; x < extra; ++x) {
            ret[write++] = 46;
            ret[write++] = 46;
            if (write == ret.length) continue;
            ret[write++] = 47;
        }
        if (matched < o.getNameCount()) {
            System.arraycopy(o.path, o.offsets[matched], ret, write, o.path.length - o.offsets[matched]);
        }
        return new RoimPath(this.fs, ret, false);
    }

    private static final boolean matches(char[] a, char[] b, int start, int end) {
        for (int x = start; x < end; ++x) {
            if (a[x] == b[x]) continue;
            return false;
        }
        return true;
    }

    @Override
    public URI toUri() {
        try {
            RoimPath resolved = (RoimPath)(this.isAbsolute() ? this.normalize() : this.toAbsolutePath().normalize());
            return new URI("roimfs", this.fs.getKey() + new String(resolved.path), null);
        }
        catch (URISyntaxException e) {
            throw new AssertionError((Object)e);
        }
    }

    @Override
    public Path toAbsolutePath() {
        if (this.isAbsolute()) {
            return this;
        }
        char[] ret = new char[this.path.length + 1];
        System.arraycopy(this.path, 0, ret, 1, this.path.length);
        ret[0] = 47;
        return new RoimPath(this.fs, ret, false);
    }

    @Override
    public Path toRealPath(LinkOption ... options) throws IOException {
        RoimPath resolved = this.getResolvedPath();
        this.fs.checkExists(resolved.toString());
        return resolved;
    }

    private RoimPath getResolvedPath() {
        if (this.resolved == null) {
            this.resolved = (RoimPath)(this.isAbsolute() ? this.normalize() : this.toAbsolutePath().normalize());
        }
        return this.resolved;
    }

    @Override
    public Path resolveSibling(String other) {
        return this.resolveSibling(this.fs.getPath(other, new String[0]));
    }

    @Override
    public Path resolveSibling(Path other) {
        Path parent = this.getParent();
        return parent == null ? other : parent.resolve(other);
    }

    @Override
    public Iterator<Path> iterator() {
        return new Iterator<Path>(){
            private int index = 0;

            @Override
            public boolean hasNext() {
                return this.index < RoimPath.this.getNameCount();
            }

            @Override
            public Path next() {
                if (this.index >= RoimPath.this.getNameCount()) {
                    throw new NoSuchElementException();
                }
                return RoimPath.this.getName(this.index++);
            }

            @Override
            public void remove() {
                throw new ReadOnlyFileSystemException();
            }
        };
    }

    @Override
    public File toFile() {
        throw new UnsupportedOperationException();
    }

    @Override
    public WatchKey register(WatchService watcher, WatchEvent.Kind<?> ... events) throws IOException {
        return this.register(watcher, events, new WatchEvent.Modifier[0]);
    }

    @Override
    public WatchKey register(WatchService watcher, WatchEvent.Kind<?>[] events, WatchEvent.Modifier ... modifiers) throws IOException {
        if (watcher == null || events == null || modifiers == null) {
            throw new NullPointerException();
        }
        throw new ProviderMismatchException();
    }
}

