/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.roimfs;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import java.nio.charset.StandardCharsets;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Locale;

public class Handler
extends URLStreamHandler {
    private static final String PROPERTY = "java.protocol.handler.pkgs";
    private static boolean registered = false;

    static void register() {
        if (registered) {
            return;
        }
        registered = true;
        String env = System.getProperty(PROPERTY);
        env = env == null ? "net.minecraftforge" : env + "|net.minecraftforge";
        System.setProperty(PROPERTY, env);
    }

    @Override
    protected URLConnection openConnection(URL url) throws IOException {
        return new Connection(url);
    }

    private static URI toUri(URL url) throws IOException {
        try {
            return url.toURI();
        }
        catch (URISyntaxException e) {
            throw new IOException("URL " + url + " cannot be converted to a URI", e);
        }
    }

    private static class Connection
    extends URLConnection {
        private InputStream stream;
        private int size;

        protected Connection(URL url) {
            super(url);
        }

        @Override
        public void connect() throws IOException {
            if (this.stream != null) {
                return;
            }
            Path path = Paths.get(Handler.toUri(this.url));
            if (Files.isDirectory(path, new LinkOption[0])) {
                StringBuilder sb = new StringBuilder();
                try (DirectoryStream<Path> files = Files.newDirectoryStream(path);){
                    for (Path file : files) {
                        sb.append(file.getFileName()).append('\n');
                    }
                }
                byte[] data = sb.toString().getBytes(StandardCharsets.UTF_8);
                this.stream = new ByteArrayInputStream(data);
                this.size = data.length;
            } else {
                this.stream = Files.newInputStream(path, new OpenOption[0]);
                this.size = (int)Files.size(path);
            }
        }

        @Override
        public InputStream getInputStream() throws IOException {
            this.connect();
            return this.stream;
        }

        @Override
        public String getHeaderField(String name) {
            try {
                this.connect();
            }
            catch (IOException e) {
                return null;
            }
            name = name.toLowerCase(Locale.ENGLISH);
            if ("content-length".equals(name)) {
                return Integer.toString(this.size);
            }
            if ("content-type".equals(name)) {
                return "application/octet-stream";
            }
            return null;
        }
    }
}

