/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.renamer.gradle.shadow.net.minecraftforge.gradleutils.shared;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.inject.Inject;
import org.gradle.api.provider.ValueSource;
import org.gradle.api.provider.ValueSourceParameters;
import org.jspecify.annotations.Nullable;

abstract class JavaForkProperties
implements ValueSource<Map<String, String>, ValueSourceParameters.None> {
    private static final List<String> CONTAINS = List.of("socksProxyHost", "socksProxyPort", "socksProxyVersion", "socksNonProxyHosts");
    private static final List<String> STARTS_WITH = List.of("http.", "https.", "ftp.", "java.net.", "javax.net.ssl.", "jdk.tls.");

    private static boolean test(String key) {
        if (CONTAINS.contains(key)) {
            return true;
        }
        for (String prefix : STARTS_WITH) {
            if (!key.startsWith(prefix)) continue;
            return true;
        }
        return false;
    }

    @Inject
    public JavaForkProperties() {
    }

    public @Nullable Map<String, String> obtain() {
        Properties systemProperties = System.getProperties();
        HashMap<String, String> forkProperties = new HashMap<String, String>(systemProperties.size());
        for (Map.Entry<Object, Object> property : systemProperties.entrySet()) {
            String key = property.getKey().toString();
            String value = property.getValue().toString();
            if (!JavaForkProperties.test(key)) continue;
            forkProperties.put(key, value);
        }
        return forkProperties;
    }
}

