/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.renamer.gradle;

import java.io.File;
import java.util.Date;
import java.util.Set;
import javax.inject.Inject;
import net.minecraftforge.renamer.gradle.RenamerExtension;
import net.minecraftforge.renamer.gradle.RenamerExtensionImpl;
import net.minecraftforge.renamer.gradle.RenamerProblems;
import net.minecraftforge.renamer.gradle.RenamerTask;
import net.minecraftforge.renamer.gradle.Tools;
import net.minecraftforge.renamer.gradle.Util;
import net.minecraftforge.renamer.gradle.shadow.net.minecraftforge.gradleutils.shared.ToolExecBase;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.Dependency;
import org.gradle.api.artifacts.PublishArtifact;
import org.gradle.api.artifacts.dsl.DependencyFactory;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.FileSystemLocation;
import org.gradle.api.file.FileSystemLocationProperty;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.logging.LogLevel;
import org.gradle.api.plugins.JavaPluginExtension;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.CacheableTask;
import org.gradle.api.tasks.Classpath;
import org.gradle.api.tasks.CompileClasspath;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFile;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.TaskDependency;
import org.gradle.api.tasks.TaskProvider;
import org.gradle.api.tasks.bundling.AbstractArchiveTask;
import org.jspecify.annotations.Nullable;

@CacheableTask
public abstract class RenameJar
extends ToolExecBase<RenamerProblems>
implements RenamerTask,
PublishArtifact {
    @InputFile
    @PathSensitive(value=PathSensitivity.RELATIVE)
    public abstract RegularFileProperty getInput();

    @InputFiles
    @Classpath
    public abstract ConfigurableFileCollection getMap();

    @OutputFile
    public abstract RegularFileProperty getOutput();

    @InputFiles
    @Optional
    @CompileClasspath
    public abstract ConfigurableFileCollection getLibraries();

    @Input
    @Optional
    public abstract Property<String> getArchiveClassifier();

    @Input
    public abstract Property<String> getArchiveExtension();

    @Internal
    protected abstract Property<Date> getArchiveDate();

    @Override
    @Inject
    protected abstract DependencyFactory getDependencyFactory();

    @Inject
    public RenameJar() {
        super(Tools.RENAMER);
        this.getStandardOutputLogLevel().convention((Object)LogLevel.INFO);
        this.getMap().convention(new Object[]{this.getProviders().provider(() -> {
            RenamerExtensionImpl renamer = (RenamerExtensionImpl)this.getProject().getExtensions().findByType(RenamerExtension.class);
            if (renamer == null) {
                return null;
            }
            return renamer.mappings;
        })});
        this.getOutput().convention(this.getObjects().fileProperty().fileProvider(this.getProviders().zip(this.getInput().getLocationOnly(), this.getArchiveClassifier().orElse((Object)""), (input, classifier) -> {
            String ext;
            File file = input.getAsFile();
            int idx = file.getName().lastIndexOf(46);
            String inputName = file.getName().substring(0, idx);
            String name = inputName + "-" + classifier + (ext = file.getName().substring(idx));
            if (name.equals(file.getName())) {
                name = inputName + classifier + "-renamed" + ext;
            }
            return new File(file.getParentFile(), name);
        })).orElse(this.getDefaultOutputFile()));
        this.getLibraries().convention(new Object[]{((JavaPluginExtension)this.getProject().getExtensions().getByType(JavaPluginExtension.class)).getSourceSets().named("main").map(SourceSet::getCompileClasspath)});
        this.getArchiveExtension().convention((Object)"jar");
        this.getArchiveDate().convention(this.getInput().map(input -> new Date(input.getAsFile().lastModified())));
    }

    public void from(AbstractArchiveTask task) {
        this.from((TaskProvider<? extends AbstractArchiveTask>)this.getProject().getTasks().named(task.getName(), AbstractArchiveTask.class));
    }

    public void from(TaskProvider<? extends AbstractArchiveTask> task) {
        this.getInput().set(task.flatMap(AbstractArchiveTask::getArchiveFile));
        this.getArchiveClassifier().set(task.flatMap(AbstractArchiveTask::getArchiveClassifier).filter(Util.STRING_IS_PRESENT).map(s -> s + "-renamed").orElse((Object)"renamed"));
        this.getArchiveExtension().set(task.flatMap(AbstractArchiveTask::getArchiveExtension).orElse((Object)"jar"));
    }

    public void mappings(String artifact) {
        this.mappings((Dependency)this.getDependencyFactory().create((CharSequence)artifact));
    }

    public void mappings(Dependency dependency) {
        Configuration configuration = this.getProject().getConfigurations().detachedConfiguration(new Dependency[]{dependency});
        configuration.setTransitive(false);
        this.setMappings((FileCollection)configuration);
    }

    public void mappings(Provider<? extends Dependency> dependency) {
        Configuration configuration = this.getProject().getConfigurations().detachedConfiguration(new Dependency[0]);
        configuration.getDependencies().addLater(dependency);
        configuration.setTransitive(false);
        this.setMappings((FileCollection)configuration);
    }

    public void setMappings(FileCollection files) {
        this.getMap().setFrom((Iterable)files);
    }

    @Override
    protected void addArguments() {
        this.args("--input", (FileSystemLocationProperty<FileSystemLocation>)this.getInput());
        this.args("--map", this.getMapFile());
        this.args("--output", (FileSystemLocationProperty<FileSystemLocation>)this.getOutput());
        this.args("--lib", (Iterable<File>)this.getLibraries());
        super.addArguments();
    }

    private File getMapFile() {
        try {
            return this.getMap().getSingleFile();
        }
        catch (IllegalStateException exception) {
            throw ((RenamerProblems)this.getProblems()).reportMultipleMapFiles(exception, this);
        }
    }

    @Deprecated
    @Internal
    public @Nullable String getClassifier() {
        return (String)this.getArchiveClassifier().getOrNull();
    }

    @Deprecated
    @Internal
    public String getExtension() {
        return (String)this.getArchiveExtension().get();
    }

    @Deprecated
    @Internal
    public String getType() {
        return this.getExtension();
    }

    @Deprecated
    @Internal
    public File getFile() {
        return (File)this.getOutput().getAsFile().get();
    }

    @Deprecated
    @Internal
    public Date getDate() {
        return (Date)this.getArchiveDate().get();
    }

    @Internal
    public TaskDependency getBuildDependencies() {
        return task -> Set.of(this);
    }
}

