/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.renamer.gradle.shadow.net.minecraftforge.gradleutils.shared.shadow.net.minecraftforge.util.hash;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.List;
import net.minecraftforge.renamer.gradle.shadow.net.minecraftforge.gradleutils.shared.shadow.net.minecraftforge.util.hash.HashFunction;

public final class HashUtils {
    public static String[] bulkHash(File file, HashFunction ... functions) throws IOException {
        if (file == null || !file.exists()) {
            return null;
        }
        MessageDigest[] digests = new MessageDigest[functions.length];
        for (int x = 0; x < functions.length; ++x) {
            digests[x] = functions[x].get();
        }
        byte[] buf = new byte[1024];
        int count = -1;
        try (FileInputStream stream = new FileInputStream(file);){
            while ((count = stream.read(buf)) != -1) {
                for (MessageDigest digest : digests) {
                    digest.update(buf, 0, count);
                }
            }
        }
        String[] ret = new String[functions.length];
        for (int x = 0; x < functions.length; ++x) {
            HashFunction func = functions[x];
            MessageDigest digest = digests[x];
            ret[x] = func.pad(new BigInteger(1, digest.digest()).toString(16));
        }
        return ret;
    }

    public static void updateHash(File target) throws IOException {
        HashUtils.updateHash(target, HashFunction.values());
    }

    public static void updateHash(File target, HashFunction ... functions) throws IOException {
        if (!target.exists()) {
            for (HashFunction func : functions) {
                File cache = new File(target.getAbsolutePath() + "." + func.extension());
                cache.delete();
            }
        } else {
            String[] hashes = HashUtils.bulkHash(target, functions);
            for (int x = 0; x < functions.length; ++x) {
                HashFunction func = functions[x];
                File cache = new File(target.getAbsolutePath() + "." + func.extension());
                Files.write(cache.toPath(), hashes[x].getBytes(), new OpenOption[0]);
            }
        }
    }

    static List<File> listFiles(File path) {
        return HashUtils.listFiles(path, new ArrayList<File>());
    }

    private static List<File> listFiles(File dir, List<File> files) {
        if (!dir.exists()) {
            return files;
        }
        if (!dir.isDirectory()) {
            throw new IllegalArgumentException("Path must be directory: " + dir.getAbsolutePath());
        }
        for (File file : dir.listFiles()) {
            if (file.isDirectory()) {
                files = HashUtils.listFiles(file, files);
                continue;
            }
            files.add(file);
        }
        return files;
    }

    static <R, E extends Throwable> R sneak(Throwable t) throws E {
        throw t;
    }

    private HashUtils() {
    }
}

