/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.renamer.gradle;

import javax.inject.Inject;
import net.minecraftforge.renamer.gradle.RenameJar;
import net.minecraftforge.renamer.gradle.RenamerExtensionInternal;
import org.gradle.api.Action;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.Dependency;
import org.gradle.api.artifacts.dsl.DependencyFactory;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.FileCollection;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.TaskProvider;

abstract class RenamerExtensionImpl
implements RenamerExtensionInternal {
    final ConfigurableFileCollection mappings = this.getObjects().fileCollection();

    @Inject
    protected abstract Project getProject();

    @Inject
    protected abstract ObjectFactory getObjects();

    @Inject
    protected abstract DependencyFactory getDependencies();

    @Inject
    public RenamerExtensionImpl() {
    }

    @Override
    public void mappings(String artifact) {
        this.mappings((Dependency)this.getDependencies().create((CharSequence)artifact));
    }

    @Override
    public void mappings(Dependency dependency) {
        Configuration configuration = this.getProject().getConfigurations().detachedConfiguration(new Dependency[]{dependency});
        configuration.setTransitive(false);
        this.setMappings((FileCollection)configuration);
    }

    @Override
    public void mappings(Provider<? extends Dependency> dependency) {
        Configuration configuration = this.getProject().getConfigurations().detachedConfiguration(new Dependency[0]);
        configuration.getDependencies().addLater(dependency);
        configuration.setTransitive(false);
        this.setMappings((FileCollection)configuration);
    }

    @Override
    public void setMappings(FileCollection files) {
        this.mappings.setFrom((Iterable)files);
    }

    @Override
    public TaskProvider<RenameJar> classes(String name, Action<? super RenameJar> action) {
        return this.getProject().getTasks().register(name, RenameJar.class, action);
    }
}

