/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.multi_release.gradle.internal;

import javax.inject.Inject;
import net.minecraftforge.multi_release.gradle.internal.shadow.net.minecraftforge.gradleutils.shared.EnhancedProblems;
import org.gradle.api.Action;
import org.gradle.api.artifacts.Dependency;
import org.gradle.api.problems.ProblemSpec;
import org.gradle.api.problems.Severity;
import org.gradle.jvm.toolchain.JavaLanguageVersion;

abstract class MultiReleaseProblems
extends EnhancedProblems {
    private static final long serialVersionUID = 9118333711048006759L;

    @Inject
    public MultiReleaseProblems() {
        super("multi-release", "Multi-Release Java");
    }

    void reportContainerNotRegistered(String extensionName) {
        this.report("multi-release-extension-without-container", "Multi-release container was not registered", (Action<? super ProblemSpec>)((Action)spec -> spec.details("Attempted to use multi-release functionality before the first container has been registered.\nThe default functionality was used: to use the 'main' sourceSet and the 'jar' task.\nIt is strongly recommended for you to declare the registration using `%s.register`, even if you are using the default functionality.".formatted(extensionName)).severity(Severity.ADVICE).solution("Register the container using `%s.register` before using any other functionality.".formatted(extensionName)).solution("Consult the documentation or ask for help on the Forge Forums, GitHub, or Discord server.")));
    }

    RuntimeException multiReleaseVersionTooLow(JavaLanguageVersion version, Dependency dependency) {
        IllegalArgumentException e = new IllegalArgumentException("Multi-release version %s is too low, minimum is 9".formatted(version));
        return this.throwing(e, "", "", (Action<? super ProblemSpec>)((Action)spec -> spec.details("Cannot add a multi-release dependency for a Java version lower than 9.\nAffected dependency: %s".formatted(dependency)).severity(Severity.ERROR).details("Use at least language level 9 for multi-release dependencies.").details("Use separately-built JARs for Java versions lower than 9 (i.e. 5, 6, and 8).").details("Consult the documentation or ask for help on the Forge Forums, GitHub, or Discord server.")));
    }
}

