/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.multi_release.gradle.internal;

import java.io.File;
import javax.inject.Inject;
import net.minecraftforge.multi_release.gradle.internal.MultiReleaseContainerInternal;
import net.minecraftforge.multi_release.gradle.internal.MultiReleaseProblems;
import net.minecraftforge.multi_release.gradle.internal.Util;
import net.minecraftforge.multi_release.gradle.internal.shadow.net.minecraftforge.gradleutils.shared.Closures;
import org.codehaus.groovy.runtime.StringGroovyMethods;
import org.gradle.api.Action;
import org.gradle.api.NamedDomainObjectProvider;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.ConsumableConfiguration;
import org.gradle.api.artifacts.Dependency;
import org.gradle.api.artifacts.dsl.DependencyFactory;
import org.gradle.api.attributes.Attribute;
import org.gradle.api.attributes.AttributeContainer;
import org.gradle.api.attributes.HasAttributes;
import org.gradle.api.component.AdhocComponentWithVariants;
import org.gradle.api.component.SoftwareComponentFactory;
import org.gradle.api.file.ArchiveOperations;
import org.gradle.api.file.CopySpec;
import org.gradle.api.file.DuplicatesStrategy;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.provider.Provider;
import org.gradle.api.provider.ProviderFactory;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.TaskProvider;
import org.gradle.api.tasks.bundling.Jar;
import org.gradle.jvm.toolchain.JavaLanguageVersion;

abstract class MultiReleaseContainerImpl
implements MultiReleaseContainerInternal {
    private final MultiReleaseProblems problems = (MultiReleaseProblems)this.getObjects().newInstance(MultiReleaseProblems.class, new Object[0]);
    private final SourceSet sourceSet;
    private final TaskProvider<? extends Jar> jar;
    private final TaskProvider<Jar> multiReleaseJar;
    private final Attribute<Boolean> attribute;
    private final NamedDomainObjectProvider<ConsumableConfiguration> apiElements;
    private final NamedDomainObjectProvider<ConsumableConfiguration> runtimeElements;
    private final AdhocComponentWithVariants softwareComponent;

    @Inject
    protected abstract Project getProject();

    @Inject
    protected abstract ObjectFactory getObjects();

    @Inject
    protected abstract ProviderFactory getProviders();

    @Inject
    protected abstract ArchiveOperations getArchiveOperations();

    @Inject
    protected abstract SoftwareComponentFactory getSoftwareComponentFactory();

    @Inject
    protected abstract DependencyFactory getDependencyFactory();

    @Inject
    public MultiReleaseContainerImpl(SourceSet sourceSet, TaskProvider<? extends Jar> jar) {
        this.sourceSet = sourceSet;
        this.jar = jar;
        this.multiReleaseJar = this.createJar();
        this.attribute = Attribute.of((String)("net.minecraftforge.multi-release." + sourceSet.getName()), Boolean.class);
        this.apiElements = this.createConfiguration((NamedDomainObjectProvider<? extends Configuration>)this.getProject().getConfigurations().named(sourceSet.getApiElementsConfigurationName()));
        this.runtimeElements = this.createConfiguration((NamedDomainObjectProvider<? extends Configuration>)this.getProject().getConfigurations().named(sourceSet.getRuntimeElementsConfigurationName()));
        this.softwareComponent = this.createSoftwareComponent();
    }

    private TaskProvider<Jar> createJar() {
        TaskProvider ret = this.getProject().getTasks().register("multiRelease" + StringGroovyMethods.capitalize((CharSequence)this.jar.getName()), Jar.class, task -> {
            task.setGroup("build");
            task.dependsOn(new Object[]{this.jar});
            task.with(new CopySpec[]{(CopySpec)this.jar.get()});
            task.setManifest(((Jar)this.jar.get()).getManifest());
            task.manifest(Closures.consumer(manifest -> manifest.getAttributes().put((Object)"Multi-Release", (Object)"true")));
            task.getArchiveClassifier().convention((Object)"mr");
        });
        this.getProject().getTasks().named("assemble").configure(task -> task.dependsOn(new Object[]{ret}));
        return ret;
    }

    private NamedDomainObjectProvider<ConsumableConfiguration> createConfiguration(NamedDomainObjectProvider<? extends Configuration> baseConfiguration) {
        return this.getProject().getConfigurations().consumable("multiRelease" + StringGroovyMethods.capitalize((CharSequence)baseConfiguration.getName()), configuration -> {
            Provider description = baseConfiguration.map(Configuration::getDescription).map(StringGroovyMethods::uncapitalize);
            if (description.isPresent()) {
                configuration.setDescription("Multi-release " + (String)description.get());
            }
            configuration.attributes(attributes -> {
                attributes.attribute(this.attribute, (Object)true);
                attributes.addAllLater((AttributeContainer)baseConfiguration.map(HasAttributes::getAttributes).get());
            });
            configuration.outgoing(outgoing -> outgoing.artifact(this.multiReleaseJar));
            configuration.extendsFrom(new Configuration[]{(Configuration)baseConfiguration.get()});
        });
    }

    private AdhocComponentWithVariants createSoftwareComponent() {
        AdhocComponentWithVariants softwareComponent = this.getSoftwareComponentFactory().adhoc("multiRelease" + (SourceSet.isMain((SourceSet)this.sourceSet) ? "" : StringGroovyMethods.capitalize((CharSequence)this.sourceSet.getName())) + "Java");
        softwareComponent.addVariantsFromConfiguration((Configuration)this.apiElements.get(), variant -> variant.mapToMavenScope("compile"));
        softwareComponent.addVariantsFromConfiguration((Configuration)this.runtimeElements.get(), variant -> variant.mapToMavenScope("runtime"));
        Util.ensureAfterEvaluate(this.getProject(), (Action<? super Project>)((Action)project -> {
            Configuration javadocElements;
            Configuration sourcesElements = (Configuration)project.getConfigurations().findByName(this.sourceSet.getSourcesElementsConfigurationName());
            if (sourcesElements != null) {
                softwareComponent.addVariantsFromConfiguration(sourcesElements, variant -> {
                    variant.mapToMavenScope("runtime");
                    variant.mapToOptional();
                });
            }
            if ((javadocElements = (Configuration)project.getConfigurations().findByName(this.sourceSet.getJavadocElementsConfigurationName())) != null) {
                softwareComponent.addVariantsFromConfiguration(javadocElements, variant -> {
                    variant.mapToMavenScope("runtime");
                    variant.mapToOptional();
                });
            }
        }));
        this.getProject().getComponents().add((Object)softwareComponent);
        return softwareComponent;
    }

    @Override
    public TaskProvider<Jar> getJar() {
        return this.multiReleaseJar;
    }

    @Override
    public NamedDomainObjectProvider<ConsumableConfiguration> getApiElements() {
        return this.apiElements;
    }

    @Override
    public NamedDomainObjectProvider<ConsumableConfiguration> getRuntimeElements() {
        return this.runtimeElements;
    }

    @Override
    public AdhocComponentWithVariants getComponent() {
        return this.softwareComponent;
    }

    @Override
    public void add(JavaLanguageVersion version, Project dependency, Action<? super Configuration> action) {
        this.add(version, (Dependency)this.getDependencyFactory().create(dependency), action);
    }

    @Override
    public void add(JavaLanguageVersion version, Dependency dependency, Action<? super Configuration> action) {
        this.add(version, this.getProject().getConfigurations().detachedConfiguration(new Dependency[]{dependency}), action);
    }

    @Override
    public void add(JavaLanguageVersion version, Provider<? extends Dependency> dependency, Action<? super Configuration> action) {
        this.add(version, this.getProject().getConfigurations().detachedConfiguration(new Dependency[0]).withDependencies(dependencies -> dependencies.addLater(dependency)), action);
    }

    private void add(JavaLanguageVersion version, Configuration configuration, Action<? super Configuration> action) {
        if (version.compareTo((Object)JavaLanguageVersion.of((int)8)) <= 0) {
            Dependency dependency = (Dependency)configuration.getDependencies().iterator().next();
            throw this.problems.multiReleaseVersionTooLow(version, dependency);
        }
        configuration.setTransitive(false);
        action.execute((Object)configuration);
        Util.ensureAfterEvaluate(this.getProject(), (Action<? super Project>)((Action)project -> ((Jar)this.multiReleaseJar.get()).configure(Closures.consumer(multiReleaseJar -> {
            multiReleaseJar.dependsOn(new Object[]{configuration.getBuildDependencies()});
            multiReleaseJar.into((Object)("META-INF/versions/" + version.asInt()), into -> {
                into.setDuplicatesStrategy(DuplicatesStrategy.WARN);
                for (File file : configuration.getFiles()) {
                    into.from((Object)this.getProviders().provider(() -> this.getArchiveOperations().zipTree((Object)file)), from -> {
                        from.setDuplicatesStrategy(DuplicatesStrategy.WARN);
                        from.exclude(new String[]{"**/META-INF/**"});
                    });
                }
            });
        }))));
    }
}

