/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.multi_release.gradle.internal;

import javax.inject.Inject;
import net.minecraftforge.multi_release.gradle.MultiReleaseContainer;
import net.minecraftforge.multi_release.gradle.internal.MultiReleaseContainerImpl;
import net.minecraftforge.multi_release.gradle.internal.MultiReleaseContainerInternal;
import net.minecraftforge.multi_release.gradle.internal.MultiReleaseExtensionInternal;
import net.minecraftforge.multi_release.gradle.internal.MultiReleaseProblems;
import net.minecraftforge.multi_release.gradle.internal.Util;
import org.gradle.api.Project;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.plugins.JavaPluginExtension;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.TaskProvider;
import org.gradle.api.tasks.bundling.Jar;
import org.jetbrains.annotations.Nullable;

abstract class MultiReleaseExtensionImpl
implements MultiReleaseExtensionInternal {
    private final String name;
    @Nullable
    private MultiReleaseContainerInternal container;
    private final MultiReleaseProblems problems = (MultiReleaseProblems)this.getObjects().newInstance(MultiReleaseProblems.class, new Object[0]);

    @Inject
    protected abstract Project getProject();

    @Inject
    protected abstract ObjectFactory getObjects();

    @Inject
    public MultiReleaseExtensionImpl(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    @Override
    public MultiReleaseContainer register() {
        SourceSet main = this.getMainSourceSet();
        return this.register(main, this.getJarTask(main));
    }

    @Override
    public MultiReleaseContainer register(Jar jar) {
        return this.register(this.findSourceSetFromJar(jar.getName()), this.getJarTask(jar.getName()));
    }

    @Override
    public MultiReleaseContainer register(TaskProvider<? extends Jar> jar) {
        return this.register(this.findSourceSetFromJar(jar.getName()), jar);
    }

    @Override
    public MultiReleaseContainer register(SourceSet sourceSet) {
        return this.register(sourceSet, this.getJarTask(sourceSet));
    }

    @Override
    public MultiReleaseContainer register(SourceSet sourceSet, Jar jar) {
        return this.register(sourceSet, this.getJarTask(jar.getName()));
    }

    @Override
    public MultiReleaseContainer register(SourceSet sourceSet, TaskProvider<? extends Jar> jar) {
        this.container = (MultiReleaseContainerInternal)this.getObjects().newInstance(MultiReleaseContainerImpl.class, new Object[]{sourceSet, jar});
        return this.container;
    }

    @Override
    public MultiReleaseContainerInternal getContainer() {
        if (this.container == null) {
            this.problems.reportContainerNotRegistered(this.getName());
            this.register();
        }
        return this.container;
    }

    private SourceSet getMainSourceSet() {
        return (SourceSet)((JavaPluginExtension)this.getProject().getExtensions().getByType(JavaPluginExtension.class)).getSourceSets().getByName("main");
    }

    private SourceSet findSourceSetFromJar(String jarTaskName) {
        SourceSet ret = Util.findSourceSetFromJar(this.getProject(), jarTaskName);
        if (ret == null) {
            throw new IllegalArgumentException("Could not find source set for jar task " + jarTaskName);
        }
        return ret;
    }

    private TaskProvider<Jar> getJarTask(String name) {
        return this.getProject().getTasks().named(name, Jar.class);
    }

    private TaskProvider<Jar> getJarTask(SourceSet sourceSet) {
        return this.getJarTask(sourceSet.getJarTaskName());
    }
}

